/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.jei.category;

import com.google.common.base.Suppliers;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.Supplier;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.client.gui.AllGuiTextures;
import snownee.lychee.client.gui.GuiGameElement;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.client.gui.ScreenElement;
import snownee.lychee.compat.JEIREI;
import snownee.lychee.compat.jei.JEICompat;
import snownee.lychee.compat.jei.SideBlockIcon;
import snownee.lychee.compat.jei.category.BaseJEICategory;
import snownee.lychee.compat.jei.category.ItemBurningRecipeCategory;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ItemShapelessRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.interaction.BlockInteractingRecipe;
import snownee.lychee.util.CommonProxy;

public abstract class ItemAndBlockBaseCategory<C extends LycheeContext, T extends LycheeRecipe<C>>
extends BaseJEICategory<C, T> {
    public Rect2i inputBlockRect = new Rect2i(30, 35, 20, 20);
    public Rect2i methodRect = new Rect2i(30, 12, 20, 20);
    private final ScreenElement mainIcon;

    public ItemAndBlockBaseCategory(List<LycheeRecipeType<C, T>> recipeTypes, ScreenElement mainIcon) {
        super(recipeTypes);
        this.mainIcon = mainIcon;
        this.infoRect.m_173049_(8, 32);
    }

    @Override
    public IDrawable createIcon(IGuiHelper guiHelper, List<T> recipes) {
        return new JEICompat.ScreenElementWrapper(new SideBlockIcon(this.mainIcon, (Supplier<BlockState>)Suppliers.memoize(() -> this.getIconBlock(recipes))));
    }

    public BlockState getIconBlock(List<T> recipes) {
        ClientPacketListener con = Minecraft.m_91087_().m_91403_();
        if (con == null) {
            return Blocks.f_50016_.m_49966_();
        }
        return JEIREI.getMostUsedBlock(recipes).getFirst();
    }

    @Nullable
    public BlockPredicate getInputBlock(T recipe) {
        return ((BlockKeyRecipe)recipe).getBlock();
    }

    public BlockState getRenderingBlock(T recipe) {
        return CommonProxy.getCycledItem(BlockPredicateHelper.getShowcaseBlockStates(this.getInputBlock(recipe)), Blocks.f_50016_.m_49966_(), 1000);
    }

    @Override
    public void setRecipe(IRecipeLayoutBuilder builder, T recipe, IFocusGroup focuses) {
        int y;
        int n = y = recipe.m_7527_().size() > 9 || recipe.showingActionsCount() > 9 ? 26 : 28;
        if (recipe instanceof ItemShapelessRecipe) {
            this.ingredientGroup(builder, recipe, 38, y);
        } else if (recipe instanceof BlockInteractingRecipe) {
            this.ingredientGroup(builder, recipe, 22, 21);
        } else {
            this.ingredientGroup(builder, recipe, 12, 21);
        }
        this.actionGroup(builder, recipe, this.getWidth() - 29, y);
        ItemAndBlockBaseCategory.addBlockIngredients(builder, recipe);
    }

    public void drawExtra(T recipe, GuiGraphics graphics, double mouseX, double mouseY, int centerX) {
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, this.methodRect.m_110085_(), this.methodRect.m_110086_());
    }

    @Override
    public void draw(T recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        this.drawInfoBadge(recipe, graphics, mouseX, mouseY);
        int centerX = this.getWidth() / 2;
        this.drawExtra(recipe, graphics, mouseX, mouseY, centerX);
        BlockState state = this.getRenderingBlock(recipe);
        if (state.m_60795_()) {
            AllGuiTextures.JEI_QUESTION_MARK.render(graphics, this.inputBlockRect.m_110085_() + 4, this.inputBlockRect.m_110086_() + 2);
            return;
        }
        PoseStack matrixStack = graphics.m_280168_();
        if (state.m_60791_() < 5) {
            matrixStack.m_85836_();
            matrixStack.m_252880_((float)(this.inputBlockRect.m_110085_() + 11), (float)(this.inputBlockRect.m_110086_() + 16), 0.0f);
            matrixStack.m_85841_(0.7f, 0.7f, 0.7f);
            AllGuiTextures.JEI_SHADOW.render(graphics, -26, -5);
            matrixStack.m_85849_();
        }
        ((RenderElement)GuiGameElement.of(state).rotateBlock(12.5, 202.5, 0.0).scale(15.0).lighting(JEIREI.BLOCK_LIGHTING).atLocal(0.0, 0.2, 0.0).at(this.inputBlockRect.m_110085_(), this.inputBlockRect.m_110086_())).render(graphics);
    }

    @Override
    public List<Component> getTooltipStrings(T recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        Component description;
        if (this.getClass() != ItemBurningRecipeCategory.class && this.inputBlockRect.m_110087_((int)mouseX, (int)mouseY)) {
            return BlockPredicateHelper.getTooltips(this.getRenderingBlock(recipe), this.getInputBlock(recipe));
        }
        if (this.methodRect.m_110087_((int)mouseX, (int)mouseY) && (description = this.getMethodDescription(recipe)) != null) {
            return List.of(description);
        }
        return super.getTooltipStrings(recipe, recipeSlotsView, mouseX, mouseY);
    }

    @Nullable
    public Component getMethodDescription(T recipe) {
        return null;
    }

    @Override
    public boolean handleInput(T recipe, double mouseX, double mouseY, InputConstants.Key input) {
        if (this.getClass() != ItemBurningRecipeCategory.class && this.inputBlockRect.m_110087_((int)mouseX, (int)mouseY)) {
            return this.clickBlock(this.getRenderingBlock(recipe), input);
        }
        return super.handleInput(recipe, mouseX, mouseY, input);
    }
}

