/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.joml.Quaternionf;
import snownee.lychee.Lychee;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.core.post.PostActionRenderer;
import snownee.lychee.client.gui.CustomLightingSettings;
import snownee.lychee.client.gui.ILightingSettings;
import snownee.lychee.compat.IngredientInfo;
import snownee.lychee.core.def.BlockPredicateHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.recipe.BlockKeyRecipe;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.util.CachedRenderingEntity;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Pair;

public class JEIREI {
    public static ILightingSettings BLOCK_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-30.0f, 45.0f).secondLightRotation(0.0f, 65.0f).build();
    public static ILightingSettings SIDE_ICON_LIGHTING = CustomLightingSettings.builder().firstLightRotation(135.0f, 35.0f).secondLightRotation(-20.0f, 50.0f).build();
    public static ILightingSettings FUSED_TNT_LIGHTING = CustomLightingSettings.builder().firstLightRotation(-120.0f, 20.0f).secondLightRotation(200.0f, 45.0f).build();
    public static final CachedRenderingEntity<PrimedTnt> TNT_ENTITY = CachedRenderingEntity.ofFactory(arg_0 -> ((EntityType)EntityType.f_20515_).m_20615_(arg_0));

    public static List<IngredientInfo> generateShapelessInputs(LycheeRecipe<?> recipe) {
        List ingredients = recipe.m_7527_().stream().map(IngredientInfo::new).collect(Collectors.toCollection(ArrayList::new));
        recipe.getPostActions().forEach(action -> PostActionRenderer.of(action).loadCatalystsInfo((PostAction)action, (ILycheeRecipe<?>)recipe, ingredients));
        if (!recipe.getType().compactInputs) {
            JEIREI.addIngredientTips(recipe, ingredients);
            return ingredients;
        }
        ArrayList newIngredients = Lists.newArrayList();
        for (IngredientInfo ingredient : ingredients) {
            IngredientInfo match = null;
            if (CommonProxy.isSimpleIngredient(ingredient.ingredient)) {
                for (IngredientInfo toCompare : newIngredients) {
                    if (!Objects.equals(toCompare.tooltips, ingredient.tooltips) || !CommonProxy.isSimpleIngredient(toCompare.ingredient) || !toCompare.ingredient.m_43931_().equals(ingredient.ingredient.m_43931_())) continue;
                    match = toCompare;
                    break;
                }
            }
            if (match == null) {
                newIngredients.add(ingredient);
                continue;
            }
            match.count += ingredient.count;
        }
        JEIREI.addIngredientTips(recipe, newIngredients);
        return newIngredients;
    }

    public static void addIngredientTips(LycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
        for (IngredientInfo ingredient : ingredients) {
            IngredientInfo.Type type = CommonProxy.getIngredientType(ingredient.ingredient);
            if (type == IngredientInfo.Type.NORMAL) continue;
            ingredient.addTooltip((Component)Component.m_237115_((String)("tip.lychee.ingredient." + type.name().toLowerCase(Locale.ROOT))));
        }
    }

    public static ResourceLocation composeCategoryIdentifier(ResourceLocation categoryId, ResourceLocation group) {
        return new ResourceLocation(categoryId.m_135827_(), "%s/%s/%s".formatted(categoryId.m_135815_(), group.m_135827_(), group.m_135815_()));
    }

    public static MutableComponent makeTitle(ResourceLocation id) {
        int i;
        String key = id.m_214296_("recipeType");
        if ("/minecraft/default".equals(key.substring(i = key.indexOf(47)))) {
            key = key.substring(0, i);
        }
        return Component.m_237115_((String)key);
    }

    public static <T extends LycheeRecipe<?>> Pair<BlockState, Integer> getMostUsedBlock(List<T> recipes) {
        Object2IntOpenHashMap blockStateCount = new Object2IntOpenHashMap();
        HashMap blockPredicateMap = Maps.newHashMap();
        for (LycheeRecipe object : recipes) {
            BlockKeyRecipe recipe = (BlockKeyRecipe)((Object)object);
            for (Block block : BlockPredicateHelper.getMatchedBlocks(recipe.getBlock())) {
                if (block.m_49966_().m_60795_()) continue;
                blockStateCount.mergeInt((Object)block, 1, Integer::sum);
                blockPredicateMap.putIfAbsent(block, recipe.getBlock());
            }
        }
        if (blockStateCount.isEmpty()) {
            return Pair.of(Blocks.f_50016_.m_49966_(), 0);
        }
        return blockStateCount.object2IntEntrySet().stream().max(Comparator.comparingInt(Object2IntMap.Entry::getIntValue)).map($ -> Pair.of(BlockPredicateHelper.anyBlockState((BlockPredicate)blockPredicateMap.get($.getKey())), $.getIntValue())).orElseGet(() -> Pair.of(Blocks.f_50016_.m_49966_(), 0));
    }

    public static void registerCategories(Predicate<ResourceLocation> categoryIdValidator, BiConsumer<ResourceLocation, CategoryCreationContext> registrar) {
        HashMap recipes = Maps.newHashMap();
        for (LycheeRecipeType<?, ?> recipeType : RecipeTypes.ALL) {
            if (!recipeType.hasStandaloneCategory) continue;
            for (LycheeRecipe recipe : recipeType.inViewerRecipes()) {
                recipes.computeIfAbsent(recipeType.categoryId, $ -> Maps.newHashMap()).computeIfAbsent(new ResourceLocation(recipe.group), $ -> Lists.newArrayList()).add(recipe);
            }
        }
        recipes.forEach((categoryId, map) -> {
            if (!categoryIdValidator.test((ResourceLocation)categoryId)) {
                Lychee.LOGGER.warn("Category factory %s does not exist".formatted(categoryId));
                return;
            }
            map.forEach((group, groupRecipes) -> {
                CategoryCreationContext context = new CategoryCreationContext((ResourceLocation)group, (List<LycheeRecipe<?>>)groupRecipes);
                registrar.accept((ResourceLocation)categoryId, context);
            });
        });
    }

    public static List<Component> getRecipeTooltip(ILycheeRecipe<?> recipe) {
        ArrayList list = Lists.newArrayList();
        if (!Strings.isNullOrEmpty((String)recipe.getComment())) {
            String comment = recipe.getComment();
            if (I18n.m_118936_((String)comment)) {
                comment = I18n.m_118938_((String)comment, (Object[])new Object[0]);
            }
            Splitter.on((char)'\n').splitToStream((CharSequence)comment).map(Component::m_237113_).forEach(list::add);
        }
        Minecraft mc = Minecraft.m_91087_();
        recipe.getContextualHolder().getConditionTooltips(list, 0, (Level)mc.f_91073_, (Player)mc.f_91074_);
        return list;
    }

    public static void renderTnt(GuiGraphics graphics, float x, float y) {
        PrimedTnt tnt = TNT_ENTITY.getEntity();
        int fuse = 80 - tnt.f_19797_ % 80;
        if (fuse >= 40) {
            return;
        }
        TNT_ENTITY.earlySetLevel();
        tnt.m_32085_(fuse);
        float toRad = (float)Math.PI / 180;
        Quaternionf quaternion = new Quaternionf().rotateXYZ(200.0f * toRad, -20.0f * toRad, 0.0f);
        FUSED_TNT_LIGHTING.applyLighting();
        TNT_ENTITY.render(graphics.m_280168_(), x, y, 20.0f, quaternion);
    }

    public record CategoryCreationContext(ResourceLocation group, List<LycheeRecipe<?>> recipes) {
    }
}

