/*
 * Decompiled with CFR 0.152.
 */
package com.mystchonky.tomeofblood.common.spell;

import com.hollingsworth.arsnouveau.api.ArsNouveauAPI;
import com.hollingsworth.arsnouveau.api.mana.IManaCap;
import com.hollingsworth.arsnouveau.api.spell.ISpellValidator;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellValidationError;
import com.hollingsworth.arsnouveau.common.util.PortUtil;
import com.hollingsworth.arsnouveau.setup.registry.CapabilityRegistry;
import com.mystchonky.tomeofblood.common.config.BaseConfig;
import com.mystchonky.tomeofblood.common.registry.LangRegistry;
import java.util.List;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import wayoftime.bloodmagic.core.data.SoulNetwork;
import wayoftime.bloodmagic.core.data.SoulTicket;
import wayoftime.bloodmagic.util.helper.NetworkHelper;

public class BloodSpellResolver
extends SpellResolver {
    private final ISpellValidator spellValidator = ArsNouveauAPI.getInstance().getSpellCastingSpellValidator();

    public BloodSpellResolver(SpellContext spellContext) {
        super(spellContext);
    }

    public boolean canCast(LivingEntity entity) {
        List validationErrors = this.spellValidator.validate(this.spell.recipe);
        if (validationErrors.isEmpty()) {
            return this.enoughSpirit(entity);
        }
        if (!this.silent && !entity.m_20193_().f_46443_) {
            PortUtil.sendMessageNoSpam((Entity)entity, (Component)((SpellValidationError)validationErrors.get(0)).makeTextComponentExisting());
        }
        return false;
    }

    boolean enoughSpirit(LivingEntity entity) {
        int totalCost = this.getResolveCost();
        IManaCap manaCap = (IManaCap)CapabilityRegistry.getMana((LivingEntity)entity).orElse(null);
        if (manaCap == null) {
            return false;
        }
        double remainder = manaCap.getCurrentMana() - (double)totalCost;
        if (remainder >= 0.0) {
            return true;
        }
        return this.enoughLP(entity, remainder *= -1.0);
    }

    boolean enoughLP(LivingEntity entity, double manaCost) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_7500_()) {
                return true;
            }
            double totalCost = manaCost * (double)((Integer)BaseConfig.COMMON.CONVERSION_RATE.get()).intValue();
            SoulNetwork soulNetwork = NetworkHelper.getSoulNetwork((UUID)player.m_20148_());
            int pool = soulNetwork.getCurrentEssence();
            if ((double)pool < totalCost) {
                PortUtil.sendMessageCenterScreen((Entity)player, (Component)Component.m_237115_((String)LangRegistry.LOW_LP.getString()));
                return false;
            }
            return true;
        }
        return false;
    }

    public void expendMana() {
        int totalCost = this.getResolveCost();
        CapabilityRegistry.getMana((LivingEntity)this.spellContext.getUnwrappedCaster()).ifPresent(mana -> {
            double remainder = mana.getCurrentMana() - (double)totalCost;
            if (remainder >= 0.0) {
                mana.removeMana((double)totalCost);
            } else {
                Player player;
                mana.removeMana(mana.getCurrentMana());
                remainder *= -1.0;
                LivingEntity patt3989$temp = this.spellContext.getUnwrappedCaster();
                if (patt3989$temp instanceof Player && !(player = (Player)patt3989$temp).m_7500_()) {
                    int cost = (int)(remainder * (double)((Integer)BaseConfig.COMMON.CONVERSION_RATE.get()).intValue());
                    SoulNetwork soulNetwork = NetworkHelper.getSoulNetwork((UUID)player.m_20148_());
                    SoulTicket ticket = new SoulTicket((Component)Component.m_237113_((String)("TomeOfBlood|" + player.m_7755_())), cost);
                    soulNetwork.syphonAndDamage(player, ticket);
                }
            }
        });
    }

    public SpellResolver getNewResolver(SpellContext context) {
        return new BloodSpellResolver(context);
    }
}

