/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.network.message;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import vazkii.psi.api.internal.PsiRenderHelper;
import vazkii.psi.common.Psi;
import vazkii.psi.common.network.MessageRegister;

public class MessageParticleTrail {
    private static final int STEPS_PER_UNIT = 4;
    private final Vec3 position;
    private final Vec3 direction;
    private final double length;
    private final int time;
    private final ItemStack cad;

    public MessageParticleTrail(Vec3 position, Vec3 direction, double length, int time, ItemStack cad) {
        this.position = position;
        this.direction = direction;
        this.length = length;
        this.time = time;
        this.cad = cad;
    }

    public MessageParticleTrail(FriendlyByteBuf buf) {
        this.position = MessageRegister.readVec3d(buf);
        this.direction = MessageRegister.readVec3d(buf);
        this.length = buf.readDouble();
        this.time = buf.m_130242_();
        this.cad = buf.m_130267_();
    }

    public void encode(FriendlyByteBuf buf) {
        MessageRegister.writeVec3d(buf, this.position);
        MessageRegister.writeVec3d(buf, this.direction);
        buf.writeDouble(this.length);
        buf.m_130130_(this.time);
        buf.m_130055_(this.cad);
    }

    public boolean receive(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            Level world = Psi.proxy.getClientWorld();
            int color = Psi.proxy.getColorForCAD(this.cad);
            float red = PsiRenderHelper.r(color);
            float green = PsiRenderHelper.g(color);
            float blue = PsiRenderHelper.b(color);
            Vec3 ray = this.direction.m_82541_().m_82490_(0.25);
            int steps = (int)(this.length * 4.0);
            for (int i = 0; i < steps; ++i) {
                double x = this.position.f_82479_ + ray.f_82479_ * (double)i;
                double y = this.position.f_82480_ + ray.f_82480_ * (double)i;
                double z = this.position.f_82481_ + ray.f_82481_ * (double)i;
                Psi.proxy.sparkleFX(world, x, y, z, red, green, blue, 0.0f, 0.0f, 0.0f, 1.0f, this.time);
            }
        });
        return true;
    }
}

