/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.tool;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.common.item.tool.IPsimetalTool;

public class ItemPsimetalPickaxe
extends PickaxeItem
implements IPsimetalTool {
    public ItemPsimetalPickaxe(Item.Properties properties) {
        super(PsiAPI.PSIMETAL_TOOL_MATERIAL, 1, -2.8f, properties);
    }

    public boolean m_6813_(ItemStack itemstack, Level world, BlockState state, BlockPos pos, LivingEntity player) {
        super.m_6813_(itemstack, world, state, pos, player);
        if (!(player instanceof Player)) {
            return false;
        }
        this.castOnBlockBreak(itemstack, (Player)player);
        return true;
    }

    public void setDamage(ItemStack stack, int damage) {
        if (damage > stack.m_41776_()) {
            damage = stack.m_41773_();
        }
        super.setDamage(stack, damage);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        if (!this.isEnabled(stack)) {
            modifiers.removeAll((Object)Attributes.f_22281_);
        }
        return modifiers;
    }

    @Nonnull
    public String m_5671_(ItemStack stack) {
        Object name = super.m_5671_(stack);
        if (!this.isEnabled(stack)) {
            name = (String)name + ".broken";
        }
        return name;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (!this.isEnabled(stack)) {
            return 1.0f;
        }
        return super.m_8102_(stack, state);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        IPsimetalTool.regen(stack, entityIn);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, @Nonnull ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level playerIn, List<Component> tooltip, TooltipFlag advanced) {
        Component componentName = ISocketable.getSocketedItemName(stack, "psimisc.none");
        tooltip.add((Component)Component.m_237110_((String)"psimisc.spell_selected", (Object[])new Object[]{componentName}));
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return IPsimetalTool.super.initCapabilities(stack, nbt);
    }
}

