/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.crafting.recipe;

import javax.annotation.Nonnull;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.Level;
import vazkii.psi.api.exosuit.IExosuitSensor;
import vazkii.psi.api.exosuit.ISensorHoldable;

public class SensorAttachRecipe
extends CustomRecipe {
    public static final SimpleCraftingRecipeSerializer<SensorAttachRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(SensorAttachRecipe::new);

    public SensorAttachRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level world) {
        boolean foundSensor = false;
        boolean foundTarget = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof ISensorHoldable && ((ISensorHoldable)stack.m_41720_()).getAttachedSensor(stack).m_41619_()) {
                if (foundTarget) {
                    return false;
                }
                foundTarget = true;
                continue;
            }
            if (stack.m_41720_() instanceof IExosuitSensor) {
                if (foundSensor) {
                    return false;
                }
                foundSensor = true;
                continue;
            }
            return false;
        }
        return foundSensor && foundTarget;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull CraftingContainer inv, RegistryAccess access) {
        ItemStack sensor = ItemStack.f_41583_;
        ItemStack target = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof IExosuitSensor) {
                sensor = stack;
                continue;
            }
            target = stack;
        }
        ItemStack copy = target.m_41777_();
        ISensorHoldable holdable = (ISensorHoldable)copy.m_41720_();
        holdable.attachSensor(copy, sensor);
        return copy;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public boolean m_5598_() {
        return true;
    }
}

