/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.common.entity;

import cofh.core.common.item.KnifeItem;
import cofh.core.init.CoreEntities;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.MathHelper;
import javax.annotation.Nullable;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.network.NetworkHooks;

public class ThrownKnife
extends AbstractArrow {
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(ThrownKnife.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected int hitTime = -1;
    protected static final ResourceKey<DamageType> KNIFE_DAMAGE = ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)new ResourceLocation("cofh_core", "knife"));

    public ThrownKnife(EntityType<? extends AbstractArrow> type, Level worldIn) {
        super(type, worldIn);
    }

    public ThrownKnife(Level world, double x, double y, double z, ItemStack stack) {
        super((EntityType)CoreEntities.THROWN_KNIFE.get(), x, y, z, world);
        this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)stack.m_41777_());
    }

    public ThrownKnife(Level world, LivingEntity owner, ItemStack stack) {
        super((EntityType)CoreEntities.THROWN_KNIFE.get(), owner, world);
        this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)stack.m_41777_());
    }

    public ItemStack m_7941_() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_ITEM_STACK);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_8119_() {
        int loyalty;
        if (this.hitTime >= 0) {
            ++this.hitTime;
        }
        Entity owner = this.m_19749_();
        if (this.hitTime > 4 && owner != null && (loyalty = Utils.getItemEnchantmentLevel(Enchantments.f_44955_, this.m_7941_())) > 0) {
            if (this.hasReturnOwner()) {
                if (this.hitTime == 5) {
                    this.m_5496_(SoundEvents.f_12516_, 10.0f, 1.0f);
                }
                this.m_36790_(true);
                Vec3 diff = owner.m_20299_(1.0f).m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + diff.f_82480_ * 0.015 * (double)loyalty, this.m_20189_());
                if (this.f_19853_.f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(diff.m_82541_().m_82490_((double)(0.05f * (float)loyalty))));
            } else {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
        super.m_8119_();
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 start, Vec3 end) {
        return this.hitTime >= 0 ? null : super.m_6351_(start, end);
    }

    protected void m_8060_(BlockHitResult result) {
        this.hitTime = 0;
        super.m_8060_(result);
        this.m_36740_(this.m_7239_());
    }

    protected void m_5790_(EntityHitResult result) {
        this.hitTime = 4;
        Entity target = result.m_82443_();
        ItemStack stack = this.m_7941_();
        if (stack.m_41720_() instanceof KnifeItem) {
            float velocity = (float)this.m_20184_().m_82553_();
            float damage = ((KnifeItem)stack.m_41720_()).m_43299_();
            damage = (float)MathHelper.clamp((double)(velocity * damage), 0.0, (double)(damage * 3.0f));
            if (target instanceof LivingEntity) {
                damage += EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)target).m_6336_());
            }
            Entity owner = this.m_19749_();
            if (target.m_6469_(this.damageSource(), damage)) {
                if (target.m_6095_() == EntityType.f_20566_) {
                    return;
                }
                if (target instanceof PartEntity) {
                    target = ((PartEntity)target).getParent();
                }
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    if (owner instanceof LivingEntity) {
                        EnchantmentHelper.m_44823_((LivingEntity)livingTarget, (Entity)owner);
                        EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)owner), (Entity)livingTarget);
                        if (owner instanceof Player) {
                            Player player = (Player)owner;
                            stack.m_41640_(livingTarget, player);
                        }
                    }
                    this.m_7761_(livingTarget);
                    target.m_20254_(4 * Utils.getItemEnchantmentLevel(Enchantments.f_44981_, stack));
                }
            }
            this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
            this.m_5496_(SoundEvents.f_12514_, 1.0f, 1.0f);
        }
    }

    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    public void m_6123_(Player player) {
        Entity entity = this.m_19749_();
        if (entity == null || entity.m_20148_() == player.m_20148_()) {
            super.m_6123_(player);
        }
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        if (nbt.m_128425_("Knife", 10)) {
            this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)ItemStack.m_41712_((CompoundTag)nbt.m_128469_("Knife")));
        }
        this.hitTime = nbt.m_128451_("HitTime");
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        nbt.m_128365_("Knife", (Tag)this.m_7941_().m_41739_(new CompoundTag()));
        nbt.m_128405_("HitTime", this.hitTime);
    }

    public void m_6901_() {
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || Utils.getItemEnchantmentLevel(Enchantments.f_44955_, this.m_7941_()) <= 0) {
            super.m_6901_();
        }
    }

    protected boolean hasReturnOwner() {
        Entity owner = this.m_19749_();
        return owner != null && owner.m_6084_() && (!(owner instanceof ServerPlayer) || !owner.m_5833_());
    }

    protected DamageSource damageSource() {
        return this.f_19853_.m_269111_().m_268998_(KNIFE_DAMAGE, (Entity)this, this.m_19749_());
    }
}

