/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.PointToPointParticle;
import cofh.core.client.particle.options.BiColorParticleOptions;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.core.util.helpers.vfx.VFXHelper;
import cofh.lib.util.helpers.MathHelper;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class StreamParticle
extends PointToPointParticle {
    protected Vec3 dest;
    protected Vec3[] path;
    protected List<Vector3f> curve;

    private StreamParticle(BiColorParticleOptions data, ClientLevel level, double sx, double sy, double sz, double ex, double ey, double ez) {
        super(data, level, sx, sy, sz, ex, ey, ez);
        this.dest = new Vec3(ex, ey, ez);
        this.path = this.findPath();
        this.curve = new ArrayList<Vector3f>(this.path.length * 4);
    }

    public void m_5989_() {
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
        }
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        if (this.c0.a <= 0) {
            return;
        }
        int total = this.path.length * 4;
        float inv = 1.0f / (float)total;
        float end = time * (float)(total - 1) / this.duration;
        int ceil = MathHelper.clamp(MathHelper.ceil(end), 1, total - 1);
        for (int i = this.curve.size(); i <= ceil; ++i) {
            Vec3 b = this.bezier((float)i * inv);
            this.curve.add(new Vector3f((float)(b.f_82479_ - this.f_107212_), (float)(b.f_82480_ - this.f_107213_), (float)(b.f_82481_ - this.f_107214_)));
        }
        float start = Math.max(0.0f, end - this.size * 4.0f);
        int floor = MathHelper.floor(start);
        Vector4f[] posns = new Vector4f[ceil - floor + 1];
        for (int i = floor; i <= ceil; ++i) {
            posns[i - floor] = MathHelper.toVector4f(this.curve.get(i));
        }
        posns[0].lerp((Vector4fc)MathHelper.toVector4f(this.curve.get(floor + 1)), start - (float)floor);
        float offset = (float)ceil - end;
        posns[posns.length - 1].lerp((Vector4fc)MathHelper.toVector4f(this.curve.get(ceil - 1)), offset);
        if (posns.length < 2) {
            return;
        }
        Matrix4f pose = stack.m_85850_().m_252922_();
        Vector3f normal = VFXHelper.normal(stack);
        for (Vector4f pos : posns) {
            pos.mul((Matrix4fc)pose);
        }
        int last = posns.length - 1;
        VFXHelper.VFXNode[] nodes = new VFXHelper.VFXNode[posns.length];
        inv = 1.0f / (float)posns.length;
        for (int i = 1; i < last; ++i) {
            float width = (MathHelper.sin((float)i + offset) * 0.1f + 0.2f) * MathHelper.easePlateau(inv);
            nodes[i] = new VFXHelper.VFXNode(posns[i], VFXHelper.axialPerp(posns[i - 1], posns[i + 1], width), width);
        }
        float width = 0.0f;
        nodes[0] = new VFXHelper.VFXNode(posns[0], VFXHelper.axialPerp(posns[0], posns[1], width), width);
        width = 0.0f;
        nodes[last] = new VFXHelper.VFXNode(posns[last], VFXHelper.axialPerp(posns[last - 1], posns[last], width), width);
        VFXHelper.renderNodes(normal, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLight, nodes, this.c0);
    }

    protected Vec3 bezier(float t) {
        Vec3[] pts = this.path;
        while (pts.length > 1) {
            Vec3[] next = new Vec3[pts.length - 1];
            for (int j = 0; j < next.length; ++j) {
                next[j] = pts[j].m_165921_(pts[j + 1], (double)t);
            }
            pts = next;
        }
        return pts[0];
    }

    protected List<Direction> successorOrder() {
        return List.of(Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.UP, Direction.DOWN);
    }

    protected Vec3[] findPath() {
        BlockPos start = BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_);
        BlockPos end = BlockPos.m_274446_((Position)this.dest);
        List<Direction> order = this.successorOrder();
        int capacity = this.distManhattan(start, end) * 2;
        ObjectHeapPriorityQueue open = new ObjectHeapPriorityQueue(capacity, Comparator.comparingInt(n -> n.total + n.heuristic));
        Object2ObjectOpenHashMap nodes = new Object2ObjectOpenHashMap(capacity);
        Node first = new Node(start, this.distManhattan(start, end));
        open.enqueue((Object)first);
        nodes.put(start, first);
        while (!open.isEmpty()) {
            Node node = (Node)open.dequeue();
            if (!node.inOpen) continue;
            for (Direction dir : order) {
                BlockPos pos = node.pos.m_121945_(dir);
                if (pos.equals((Object)end)) {
                    return new Node(node, pos, 0, 0).toPath();
                }
                Node successor = (Node)nodes.get(pos);
                if (successor == null) {
                    int cost = this.f_107208_.m_46859_(pos) ? 1 : 6;
                    successor = new Node(node, pos, cost, this.distManhattan(pos, end));
                } else if (successor.inOpen) {
                    total = successor.cost + node.total;
                    if (total >= successor.total) continue;
                    successor.inOpen = false;
                    successor = successor.copy(node, total);
                } else {
                    total = successor.cost + node.total;
                    if (total >= successor.total) continue;
                    successor = successor.copy(node, total);
                }
                nodes.put(pos, successor);
                open.enqueue((Object)successor);
            }
        }
        return new Vec3[0];
    }

    protected int distManhattan(BlockPos a, BlockPos b) {
        return Math.abs(a.m_123341_() - b.m_123341_()) + Math.abs(a.m_123342_() - b.m_123342_()) + Math.abs(a.m_123343_() - b.m_123343_());
    }

    @Nonnull
    public static ParticleProvider<BiColorParticleOptions> factory(SpriteSet spriteSet) {
        return StreamParticle::new;
    }

    protected static class Node {
        public final Node parent;
        public final int total;
        public final BlockPos pos;
        public final int cost;
        public final int heuristic;
        public boolean inOpen;

        private Node(Node parent, BlockPos pos, int cost, int total, int heuristic, boolean inOpen) {
            this.parent = parent;
            this.total = total;
            this.pos = pos;
            this.cost = cost;
            this.heuristic = heuristic;
            this.inOpen = inOpen;
        }

        public Node(BlockPos pos, int heuristic) {
            this(null, pos, 0, 0, heuristic, true);
        }

        public Node(Node parent, BlockPos pos, int cost, int heuristic) {
            this(parent, pos, cost, parent.total + cost, heuristic, true);
        }

        public boolean equals(Node other) {
            return this.pos.equals((Object)other.pos);
        }

        public Node copy(Node parent, int total) {
            return new Node(parent, this.pos, this.cost, total, this.heuristic, true);
        }

        public Vec3[] toPath() {
            return (Vec3[])Lists.reverse(Stream.iterate(this, n -> n.parent != null, n -> n.parent).map(n -> n.pos).map(Vec3::m_82512_).toList()).toArray(Vec3[]::new);
        }
    }
}

