/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.EntityIngredient;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.foundry.recipes.FoundryRecipe;
import fr.lucreeper74.createmetallurgy.registries.CMRecipeTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Recipe;

public class EntityMeltingRecipe
extends FoundryRecipe {
    protected EntityIngredient entityIngredient = EntityIngredient.EMPTY;

    public EntityMeltingRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(CMRecipeTypes.ENTITY_MELTING, params);
    }

    @Override
    protected boolean canSpecifyDuration() {
        return false;
    }

    public boolean matches(CrucibleBlockEntity be, Recipe<?> recipe, EntityType<?> type) {
        return EntityMeltingRecipe.bulkMatch(be, recipe) && this.entityIngredient.test(type);
    }

    public EntityIngredient getEntityIngredient() {
        return this.entityIngredient;
    }

    @Override
    public void readAdditional(JsonObject json) {
        super.readAdditional(json);
        this.entityIngredient = EntityIngredient.deserialize((JsonElement)json.getAsJsonObject("entity"));
    }

    @Override
    public void writeAdditional(JsonObject json) {
        super.writeAdditional(json);
        json.add("entity", (JsonElement)this.entityIngredient.serialize());
    }

    @Override
    public void readAdditional(FriendlyByteBuf buffer) {
        super.readAdditional(buffer);
        this.entityIngredient = EntityIngredient.read(buffer);
    }

    @Override
    public void writeAdditional(FriendlyByteBuf buffer) {
        super.writeAdditional(buffer);
        this.entityIngredient.write(buffer);
    }
}

