/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedtunnels.part;

import javax.annotation.Nonnull;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.cyclops.integratedtunnels.GeneralConfig;
import org.cyclops.integratedtunnels.api.network.IFluidNetwork;
import org.cyclops.integratedtunnels.capability.network.FluidNetworkConfig;
import org.cyclops.integratedtunnels.core.part.IPartTypeInterfacePositionedAddon;
import org.cyclops.integratedtunnels.core.part.PartTypeInterfacePositionedAddon;

public class PartTypeInterfaceFluid
extends PartTypeInterfacePositionedAddon<IFluidNetwork, IFluidHandler, PartTypeInterfaceFluid, State> {
    public PartTypeInterfaceFluid(String name) {
        super(name);
    }

    @Override
    public Capability<IFluidNetwork> getNetworkCapability() {
        return FluidNetworkConfig.CAPABILITY;
    }

    @Override
    public Capability<IFluidHandler> getTargetCapability() {
        return ForgeCapabilities.FLUID_HANDLER;
    }

    protected State constructDefaultState() {
        return new State();
    }

    public int getConsumptionRate(State state) {
        return GeneralConfig.interfaceFluidBaseConsumption;
    }

    public static class State
    extends PartTypeInterfacePositionedAddon.State<IFluidNetwork, IFluidHandler, PartTypeInterfaceFluid, State> {
        @Override
        public Capability<IFluidHandler> getTargetCapability() {
            return ForgeCapabilities.FLUID_HANDLER;
        }

        @Override
        public IFluidHandler getCapabilityInstance() {
            return new FluidHandler(this);
        }
    }

    public static class FluidHandler
    implements IFluidHandler {
        private final IPartTypeInterfacePositionedAddon.IState<IFluidNetwork, IFluidHandler, ?, ?> state;

        public FluidHandler(IPartTypeInterfacePositionedAddon.IState<IFluidNetwork, IFluidHandler, ?, ?> state) {
            this.state = state;
        }

        protected IFluidHandler getFluidHandler() {
            return (IFluidHandler)this.state.getPositionedAddonsNetwork().getChannelExternal(ForgeCapabilities.FLUID_HANDLER, this.state.getChannel());
        }

        public int getTanks() {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getFluidHandler().getTanks();
            this.state.enablePosition();
            return ret;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (!this.state.isNetworkAndPositionValid()) {
                return FluidStack.EMPTY;
            }
            this.state.disablePosition();
            FluidStack ret = this.getFluidHandler().getFluidInTank(tank);
            this.state.enablePosition();
            return ret;
        }

        public int getTankCapacity(int tank) {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getFluidHandler().getTankCapacity(tank);
            this.state.enablePosition();
            return ret;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            if (!this.state.isNetworkAndPositionValid()) {
                return false;
            }
            this.state.disablePosition();
            boolean ret = this.getFluidHandler().isFluidValid(tank, stack);
            this.state.enablePosition();
            return ret;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.state.isNetworkAndPositionValid()) {
                return 0;
            }
            this.state.disablePosition();
            int ret = this.getFluidHandler().fill(resource, action);
            this.state.enablePosition();
            return ret;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (!this.state.isNetworkAndPositionValid()) {
                return FluidStack.EMPTY;
            }
            this.state.disablePosition();
            FluidStack ret = this.getFluidHandler().drain(resource, action);
            this.state.enablePosition();
            return ret;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (!this.state.isNetworkAndPositionValid()) {
                return FluidStack.EMPTY;
            }
            this.state.disablePosition();
            FluidStack ret = this.getFluidHandler().drain(maxDrain, action);
            this.state.enablePosition();
            return ret;
        }
    }
}

