/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.infobook.pageelement;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.cyclops.cyclopscore.helper.AdvancementHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.infobook.AdvancedButton;
import org.cyclops.cyclopscore.infobook.IInfoBook;
import org.cyclops.cyclopscore.infobook.InfoSection;
import org.cyclops.cyclopscore.infobook.ScreenInfoBook;
import org.cyclops.cyclopscore.infobook.pageelement.AdvancementRewards;
import org.cyclops.cyclopscore.infobook.pageelement.IReward;

@OnlyIn(value=Dist.CLIENT)
public class AchievementCollectButton
extends AdvancedButton {
    private final AdvancementRewards advancementRewards;
    private final IInfoBook infoBook;

    public AchievementCollectButton(AdvancementRewards advancementRewards, IInfoBook infoBook) {
        this.advancementRewards = advancementRewards;
        this.infoBook = infoBook;
    }

    protected IInfoBook getInfoBook() {
        return this.infoBook;
    }

    @Override
    public void renderTooltip(GuiGraphics guiGraphics, Font font, int mx, int my) {
        super.renderTooltip(guiGraphics, font, mx, my);
        guiGraphics.m_280168_().m_85836_();
        if (mx >= this.m_252754_() && my >= this.m_252907_() && mx <= this.m_252754_() + this.f_93618_ && my <= this.m_252907_() + this.f_93619_) {
            ArrayList lines = Lists.newArrayList();
            if (this.advancementRewards.isObtained((Player)Minecraft.m_91087_().f_91074_)) {
                lines.add(FormattedCharSequence.m_13714_((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collected", new Object[0]), (Style)Style.f_131099_.m_131155_(Boolean.valueOf(true))));
            } else {
                lines.add(FormattedCharSequence.m_13714_((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collect", new Object[0]), (Style)Style.f_131099_.m_131136_(Boolean.valueOf(true))));
                boolean canObtain = true;
                for (IReward reward : this.advancementRewards.getRewards()) {
                    if (reward.canObtain((Player)Minecraft.m_91087_().f_91074_)) continue;
                    canObtain = false;
                }
                if (!canObtain) {
                    lines.add(FormattedCharSequence.m_13714_((String)L10NHelpers.localize("gui." + this.getInfoBook().getMod().getModId() + ".rewards.collectFailure", new Object[0]), (Style)Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED))));
                }
            }
            guiGraphics.m_280245_(font, (List)lines, mx, my);
        }
        guiGraphics.m_280168_().m_85849_();
        GlStateManager._enableBlend();
        GlStateManager._blendFunc((int)770, (int)771);
    }

    @Override
    public boolean isVisible() {
        return this.f_93624_;
    }

    @Override
    public void m_5691_() {
        super.m_5691_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        boolean canObtain = true;
        for (ResourceLocation advancement : this.advancementRewards.getAdvancements()) {
            if (AdvancementHelpers.hasAdvancementUnlocked((Player)Minecraft.m_91087_().f_91074_, advancement)) continue;
            canObtain = false;
        }
        for (IReward reward : this.advancementRewards.getRewards()) {
            if (reward.canObtain((Player)player)) continue;
            canObtain = false;
        }
        if (canObtain) {
            this.advancementRewards.obtain((Player)player);
        }
    }

    @Override
    public void update(int x, int y, Component displayName, InfoSection target, ScreenInfoBook gui) {
        super.update(x, y, displayName, target, gui);
        this.f_93618_ = 80;
    }
}

