/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.BasePacket;
import appeng.helpers.IMouseWheelItem;
import io.netty.buffer.Unpooled;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class MouseWheelPacket
extends BasePacket {
    private boolean wheelUp;

    public MouseWheelPacket(FriendlyByteBuf byteBuf) {
        this.wheelUp = byteBuf.readBoolean();
    }

    public MouseWheelPacket(boolean wheelUp) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(this.getPacketID());
        data.writeBoolean(wheelUp);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(ServerPlayer player) {
        ItemStack mainHand = player.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHand = player.m_21120_(InteractionHand.OFF_HAND);
        Item item = mainHand.m_41720_();
        if (item instanceof IMouseWheelItem) {
            IMouseWheelItem mouseWheelItem = (IMouseWheelItem)item;
            mouseWheelItem.onWheel(mainHand, this.wheelUp);
        } else {
            item = offHand.m_41720_();
            if (item instanceof IMouseWheelItem) {
                IMouseWheelItem mouseWheelItem = (IMouseWheelItem)item;
                mouseWheelItem.onWheel(offHand, this.wheelUp);
            }
        }
    }
}

