/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.spell.tick;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.Spells;
import sirttas.elementalcraft.spell.tick.SpellTickHelper;

public class SpellTickCooldownMessage {
    private final Spell spell;

    public SpellTickCooldownMessage(Spell spell) {
        this.spell = spell;
    }

    public static SpellTickCooldownMessage decode(FriendlyByteBuf buf) {
        return new SpellTickCooldownMessage((Spell)Spells.REGISTRY.get().getValue(buf.m_130281_()));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130085_(this.spell.getKey());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                this.startCooldown();
            }
        });
        ctx.get().setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private void startCooldown() {
        SpellTickHelper.startCooldown((ICapabilityProvider)Minecraft.m_91087_().f_91074_, this.spell);
    }
}

