/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.recipe;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.pureinfuser.PureInfuserBlockEntity;
import sirttas.elementalcraft.recipe.ECRecipeSerializers;
import sirttas.elementalcraft.recipe.ECRecipeTypes;
import sirttas.elementalcraft.recipe.IContainerBlockEntityRecipe;
import sirttas.elementalcraft.recipe.RecipeHelper;

public class PureInfusionRecipe
implements IContainerBlockEntityRecipe<PureInfuserBlockEntity> {
    public static final String NAME = "pureinfusion";
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack output;
    private final int elementAmount;
    private final ResourceLocation id;

    public PureInfusionRecipe(ResourceLocation id, int elementAmount, ItemStack output, List<Ingredient> ingredients) {
        this.id = id;
        this.ingredients = NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])((Ingredient[])ingredients.toArray(Ingredient[]::new)));
        this.output = output;
        this.elementAmount = elementAmount;
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registry) {
        return this.output;
    }

    @Override
    public boolean matches(@Nonnull PureInfuserBlockEntity inv, @Nonnull Level level) {
        return ((Ingredient)this.ingredients.get(0)).test(inv.getItem()) && ((Ingredient)this.ingredients.get(1)).test(inv.getStackInPedestal(ElementType.WATER)) && ((Ingredient)this.ingredients.get(2)).test(inv.getStackInPedestal(ElementType.FIRE)) && ((Ingredient)this.ingredients.get(3)).test(inv.getStackInPedestal(ElementType.EARTH)) && ((Ingredient)this.ingredients.get(4)).test(inv.getStackInPedestal(ElementType.AIR));
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ECRecipeSerializers.PURE_INFUSION.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return (RecipeType)ECRecipeTypes.PURE_INFUSION.get();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    @NotNull
    public ItemStack assemble(@Nonnull PureInfuserBlockEntity inv, @Nonnull RegistryAccess registry) {
        return this.m_8043_(registry).m_41777_();
    }

    public int getElementAmount() {
        return this.elementAmount;
    }

    public static class Serializer
    implements RecipeSerializer<PureInfusionRecipe> {
        @Nonnull
        public PureInfusionRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            int elementAmount = GsonHelper.m_13927_((JsonObject)json, (String)"element_amount");
            NonNullList<Ingredient> ingredients = RecipeHelper.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            ItemStack output = RecipeHelper.readRecipeOutput(json, "output");
            return new PureInfusionRecipe(recipeId, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public PureInfusionRecipe fromNetwork(@Nonnull ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int elementAmount = buffer.readInt();
            ItemStack output = buffer.m_130267_();
            int i = buffer.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
            return new PureInfusionRecipe(recipeId, elementAmount, output, (List<Ingredient>)ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, PureInfusionRecipe recipe) {
            buffer.writeInt(recipe.elementAmount);
            buffer.m_130055_(recipe.output);
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
        }
    }
}

