/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item.holder;

import java.util.Optional;
import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.source.ISourceInteractable;
import sirttas.elementalcraft.api.tooltip.ElementGaugeTooltip;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.item.ECItem;
import sirttas.elementalcraft.particle.ParticleHelper;
import sirttas.elementalcraft.property.ECProperties;

public abstract class AbstractElementHolderItem
extends ECItem
implements ISourceInteractable {
    private static final String SAVED_POS = "saved_pos";
    private final IntSupplier elementCapacity;
    private final IntSupplier transferAmount;

    protected AbstractElementHolderItem(IntSupplier elementCapacity, IntSupplier transferAmount) {
        super(ECProperties.Items.ITEM_UNSTACKABLE);
        this.elementCapacity = elementCapacity;
        this.transferAmount = transferAmount;
    }

    public abstract IElementStorage getElementStorage(ItemStack var1);

    public int m_8105_(@Nonnull ItemStack stack) {
        return this.getElementCapacity() / this.getTransferAmount();
    }

    public int getElementCapacity() {
        return this.elementCapacity.getAsInt();
    }

    public int getTransferAmount() {
        return this.transferAmount.getAsInt();
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    protected boolean isValidSource(BlockState state) {
        return state.m_60734_() == ECBlocks.SOURCE.get();
    }

    @Override
    public boolean canInteractWithSource(ItemStack stack, BlockState state) {
        return this.isValidSource(state);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        InteractionResult result = this.tick(level, (LivingEntity)player, pos, stack);
        if (result.m_19077_()) {
            this.setSavedPos(stack, pos);
            player.m_6672_(context.m_43724_());
        }
        return result;
    }

    public void m_5929_(@Nonnull Level level, @Nonnull LivingEntity player, @Nonnull ItemStack stack, int count) {
        double reach;
        BlockPos pos = this.getSavedPos(stack);
        AttributeInstance reachAttribute = player.m_21051_((Attribute)ForgeMod.ENTITY_REACH.get());
        double d = reach = reachAttribute != null ? reachAttribute.m_22135_() : 5.0;
        if (player.m_20183_().m_123331_((Vec3i)pos) + 1.0 > reach * reach || !this.tick(player.m_9236_(), player, pos, stack).m_19077_()) {
            player.m_21253_();
        }
    }

    public void m_5551_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity entityLiving, int timeLeft) {
        this.removeSavedPos(stack);
    }

    protected abstract ElementType getElementType(IElementStorage var1, BlockState var2);

    private InteractionResult tick(Level level, LivingEntity entity, BlockPos pos, ItemStack stack) {
        int amount = this.transferAmount.getAsInt();
        BlockState blockstate = level.m_8055_(pos);
        return BlockEntityHelper.getElementStorageAt((LevelReader)level, pos).map(storage -> {
            IElementStorage holder = this.getElementStorage(stack);
            boolean isSource = this.isValidSource(blockstate);
            ElementType elementType = this.getElementType((IElementStorage)storage, blockstate);
            if (elementType != ElementType.NONE) {
                if (isSource || entity.m_6144_()) {
                    if (isSource || storage.canPipeExtract(elementType, null)) {
                        int value = storage.transferTo(holder, elementType, amount);
                        if (value > 0) {
                            ParticleHelper.createElementFlowParticle(elementType, level, Vec3.m_82512_((Vec3i)pos), entity.m_7398_(0.0f), level.f_46441_);
                            return InteractionResult.CONSUME;
                        }
                        return InteractionResult.PASS;
                    }
                } else if (storage.canPipeInsert(elementType, null)) {
                    int value = holder.transferTo((IElementStorage)storage, elementType, amount);
                    if (value > 0) {
                        ParticleHelper.createElementFlowParticle(elementType, level, entity.m_7398_(0.0f), Vec3.m_82512_((Vec3i)pos), level.f_46441_);
                        return InteractionResult.CONSUME;
                    }
                    return InteractionResult.PASS;
                }
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public BlockPos getSavedPos(ItemStack stack) {
        CompoundTag savedPos;
        CompoundTag tag = stack.m_41783_();
        if (tag != null && (savedPos = tag.m_128469_(SAVED_POS)) != null) {
            return NbtUtils.m_129239_((CompoundTag)savedPos);
        }
        return null;
    }

    public void setSavedPos(ItemStack stack, BlockPos pos) {
        stack.m_41784_().m_128365_(SAVED_POS, (Tag)NbtUtils.m_129224_((BlockPos)pos));
    }

    public void removeSavedPos(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null) {
            tag.m_128473_(SAVED_POS);
        }
    }

    @Nonnull
    public Optional<TooltipComponent> m_142422_(@Nonnull ItemStack stack) {
        return ElementStorageHelper.get((ICapabilityProvider)stack).map(ElementGaugeTooltip::new);
    }
}

