/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.item;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.element.storage.single.SingleElementStorage;
import sirttas.elementalcraft.api.rune.Rune;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.container.AbstractElementContainerBlock;
import sirttas.elementalcraft.interaction.ECinteractions;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.holder.ElementHolderItem;
import sirttas.elementalcraft.item.holder.PureElementHolderItem;
import sirttas.elementalcraft.item.jewel.JewelItem;
import sirttas.elementalcraft.item.rune.RuneItem;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.jewel.Jewel;
import sirttas.elementalcraft.jewel.Jewels;
import sirttas.elementalcraft.spell.Spell;
import sirttas.elementalcraft.spell.SpellHelper;
import sirttas.elementalcraft.spell.Spells;

@Mod.EventBusSubscriber(modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECCreativeModeTabs {
    private static final DeferredRegister<CreativeModeTab> DEFERRED_REGISTER = DeferredRegister.create((ResourceKey)BuiltInRegistries.f_279662_.m_123023_(), (String)"elementalcraft");
    public static final RegistryObject<CreativeModeTab> ELEMENTAL_CRAFT_CREATIVE_TAB = DEFERRED_REGISTER.register("elemental_craft", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.elementalcraft")).m_257737_(() -> new ItemStack((ItemLike)ECItems.FOCUS.get())).m_257501_((p, o) -> {
        o.m_246326_((ItemLike)ECBlocks.EXTRACTOR.get());
        o.m_246326_((ItemLike)ECBlocks.EXTRACTOR_IMPROVED.get());
        o.m_246326_((ItemLike)ECBlocks.EVAPORATOR.get());
        o.m_246326_((ItemLike)ECBlocks.INFUSER.get());
        o.m_246326_((ItemLike)ECBlocks.SOLAR_SYNTHESIZER.get());
        if (ECinteractions.isBotaniaActive()) {
            o.m_246326_((ItemLike)ECBlocks.MANA_SYNTHESIZER.get());
        }
        o.m_246326_((ItemLike)ECBlocks.DIFFUSER.get());
        o.m_246326_((ItemLike)ECBlocks.BINDER.get());
        o.m_246326_((ItemLike)ECBlocks.BINDER_IMPROVED.get());
        o.m_246326_((ItemLike)ECBlocks.CRYSTALLIZER.get());
        o.m_246326_((ItemLike)ECBlocks.INSCRIBER.get());
        o.m_246326_((ItemLike)ECBlocks.WATER_MILL_GRINDSTONE.get());
        o.m_246326_((ItemLike)ECBlocks.AIR_MILL_GRINDSTONE.get());
        o.m_246326_((ItemLike)ECBlocks.WATER_MILL_WOOD_SAW.get());
        o.m_246326_((ItemLike)ECBlocks.AIR_MILL_WOOD_SAW.get());
        o.m_246326_((ItemLike)ECBlocks.FIRE_PEDESTAL.get());
        o.m_246326_((ItemLike)ECBlocks.WATER_PEDESTAL.get());
        o.m_246326_((ItemLike)ECBlocks.EARTH_PEDESTAL.get());
        o.m_246326_((ItemLike)ECBlocks.AIR_PEDESTAL.get());
        o.m_246326_((ItemLike)ECBlocks.PURE_INFUSER.get());
        o.m_246326_((ItemLike)ECBlocks.FIRE_FURNACE.get());
        o.m_246326_((ItemLike)ECBlocks.FIRE_BLAST_FURNACE.get());
        o.m_246326_((ItemLike)ECBlocks.PURIFIER.get());
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.SMALL_CONTAINER);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.CONTAINER);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.FIRE_RESERVOIR);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.WATER_RESERVOIR);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.EARTH_RESERVOIR);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.AIR_RESERVOIR);
        ECCreativeModeTabs.generateElementContainer(o, ECBlocks.CREATIVE_CONTAINER);
        o.m_246326_((ItemLike)ECBlocks.PIPE_IMPAIRED.get());
        o.m_246326_((ItemLike)ECBlocks.PIPE.get());
        o.m_246326_((ItemLike)ECBlocks.PIPE_IMPROVED.get());
        o.m_246326_((ItemLike)ECBlocks.PIPE_CREATIVE.get());
        o.m_246326_((ItemLike)ECItems.COVER_FRAME.get());
        o.m_246326_((ItemLike)ECItems.ELEMENT_PUMP.get());
        o.m_246326_((ItemLike)ECItems.PIPE_PRIORITY_RINGS.get());
        o.m_246326_((ItemLike)ECItems.ELEMENT_VALVE.get());
        o.m_246326_((ItemLike)ECItems.ELEMENT_BEAM.get());
        o.m_246326_((ItemLike)ECBlocks.RETRIEVER.get());
        o.m_246326_((ItemLike)ECBlocks.SORTER.get());
        o.m_246326_((ItemLike)ECBlocks.SPELL_DESK.get());
        o.m_246326_((ItemLike)ECBlocks.FIRE_PYLON.get());
        o.m_246326_((ItemLike)ECBlocks.VACUUM_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.GROWTH_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.HARVEST_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.LUMBER_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.LAVA_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.ORE_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.OVERLOAD_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.SWEET_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.ENDER_LOCK_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.BREEDING_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.GROVE_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.SPRING_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.BUDDING_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.SPAWNING_SHRINE.get());
        o.m_246326_((ItemLike)ECBlocks.ACCELERATION_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.OVERCLOCKED_ACCELERATION_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.RANGE_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.CAPACITY_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.EFFICIENCY_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.STRENGTH_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.OPTIMIZATION_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.FORTUNE_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.SILK_TOUCH_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.PLANTING_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.BONELESS_GROWTH_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.PICKUP_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.VORTEX_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.NECTAR_SHRINE_UPGRADE.get());
        if (ECinteractions.isBotaniaActive()) {
            o.m_246326_((ItemLike)ECBlocks.MYSTICAL_GROVE_SHRINE_UPGRADE.get());
        }
        o.m_246326_((ItemLike)ECBlocks.STEM_POLLINATION_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.PROTECTION_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.FILLING_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.SPRINGALINE_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.CRYSTAL_HARVEST_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.CRYSTAL_GROWTH_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.TRANSLOCATION_SHRINE_UPGRADE.get());
        o.m_246326_((ItemLike)ECBlocks.BROKEN_SOURCE_DISPLACEMENT_PLATE.get());
        o.m_246326_((ItemLike)ECBlocks.FIRE_SOURCE_DISPLACEMENT_PLATE.get());
        o.m_246326_((ItemLike)ECBlocks.WATER_SOURCE_DISPLACEMENT_PLATE.get());
        o.m_246326_((ItemLike)ECBlocks.EARTH_SOURCE_DISPLACEMENT_PLATE.get());
        o.m_246326_((ItemLike)ECBlocks.AIR_SOURCE_DISPLACEMENT_PLATE.get());
        o.m_246326_((ItemLike)ECBlocks.SOURCE_BREEDER.get());
        o.m_246326_((ItemLike)ECBlocks.SOURCE_BREEDER_PEDESTAL.get());
        o.m_246326_((ItemLike)ECItems.ARTIFICIAL_FIRE_SOURCE_SEED.get());
        o.m_246326_((ItemLike)ECItems.ARTIFICIAL_WATER_SOURCE_SEED.get());
        o.m_246326_((ItemLike)ECItems.ARTIFICIAL_EARTH_SOURCE_SEED.get());
        o.m_246326_((ItemLike)ECItems.ARTIFICIAL_AIR_SOURCE_SEED.get());
        o.m_246326_((ItemLike)ECItems.NATURAL_FIRE_SOURCE_SEED.get());
        o.m_246326_((ItemLike)ECItems.NATURAL_WATER_SOURCE_SEED.get());
        o.m_246326_((ItemLike)ECItems.NATURAL_EARTH_SOURCE_SEED.get());
        o.m_246326_((ItemLike)ECItems.NATURAL_AIR_SOURCE_SEED.get());
        o.m_246326_((ItemLike)ECBlocks.TRANSLOCATION_ANCHOR.get());
        o.m_246326_((ItemLike)ECBlocks.CRYSTAL_ORE.get());
        o.m_246326_((ItemLike)ECBlocks.DEEPSLATE_CRYSTAL_ORE.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK_SLAB.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK_STAIRS.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK_WALL.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK_FENCE.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK_BRICK.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK_BRICK_SLAB.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK_BRICK_STAIRS.get());
        o.m_246326_((ItemLike)ECBlocks.WHITE_ROCK_BRICK_WALL.get());
        o.m_246326_((ItemLike)ECBlocks.MOSSY_WHITE_ROCK.get());
        o.m_246326_((ItemLike)ECBlocks.MOSSY_WHITE_ROCK_SLAB.get());
        o.m_246326_((ItemLike)ECBlocks.MOSSY_WHITE_ROCK_STAIRS.get());
        o.m_246326_((ItemLike)ECBlocks.MOSSY_WHITE_ROCK_WALL.get());
        o.m_246326_((ItemLike)ECBlocks.BURNT_WHITE_ROCK.get());
        o.m_246326_((ItemLike)ECBlocks.BURNT_WHITE_ROCK_SLAB.get());
        o.m_246326_((ItemLike)ECBlocks.BURNT_WHITE_ROCK_STAIRS.get());
        o.m_246326_((ItemLike)ECBlocks.BURNT_WHITE_ROCK_WALL.get());
        o.m_246326_((ItemLike)ECBlocks.BURNT_GLASS.get());
        o.m_246326_((ItemLike)ECBlocks.BURNT_GLASS_PANE.get());
        o.m_246326_((ItemLike)ECBlocks.PURE_ROCK.get());
        o.m_246326_((ItemLike)ECBlocks.PURE_ROCK_SLAB.get());
        o.m_246326_((ItemLike)ECBlocks.PURE_ROCK_STAIRS.get());
        o.m_246326_((ItemLike)ECBlocks.PURE_ROCK_WALL.get());
        ECCreativeModeTabs.generateElementopedia(o);
        o.m_246326_((ItemLike)ECItems.FOCUS.get());
        o.m_246326_((ItemLike)ECItems.STAFF.get());
        ECCreativeModeTabs.generateSpells(o);
        o.m_246326_((ItemLike)ECItems.SPELL_BOOK.get());
        o.m_246326_((ItemLike)ECItems.SOURCE_ANALYSIS_GLASS.get());
        ECCreativeModeTabs.generateReceptacles(o);
        o.m_246326_((ItemLike)ECItems.SOURCE_STABILIZER.get());
        ECCreativeModeTabs.generateElementHolder(o, ECItems.FIRE_HOLDER);
        ECCreativeModeTabs.generateElementHolder(o, ECItems.WATER_HOLDER);
        ECCreativeModeTabs.generateElementHolder(o, ECItems.EARTH_HOLDER);
        ECCreativeModeTabs.generateElementHolder(o, ECItems.AIR_HOLDER);
        o.m_246326_((ItemLike)ECItems.PURE_HOLDER_CORE.get());
        ECCreativeModeTabs.generatePureElementHolder(o);
        o.m_246326_((ItemLike)ECItems.CHISEL.get());
        o.m_246326_((ItemLike)ECItems.ELEMENTAL_FIREFUEL.get());
        ECCreativeModeTabs.generatePureOres(o);
        o.m_246326_((ItemLike)ECItems.INERT_CRYSTAL.get());
        o.m_246326_((ItemLike)ECBlocks.INERT_CRYSTAL_BLOCK.get());
        o.m_246326_((ItemLike)ECItems.CONTAINED_CRYSTAL.get());
        o.m_246326_((ItemLike)ECItems.STRONGLY_CONTAINED_CRYSTAL.get());
        o.m_246326_((ItemLike)ECItems.FIRE_CRYSTAL.get());
        o.m_246326_((ItemLike)ECBlocks.FIRE_CRYSTAL_BLOCK.get());
        o.m_246326_((ItemLike)ECItems.WATER_CRYSTAL.get());
        o.m_246326_((ItemLike)ECBlocks.WATER_CRYSTAL_BLOCK.get());
        o.m_246326_((ItemLike)ECItems.EARTH_CRYSTAL.get());
        o.m_246326_((ItemLike)ECBlocks.EARTH_CRYSTAL_BLOCK.get());
        o.m_246326_((ItemLike)ECItems.AIR_CRYSTAL.get());
        o.m_246326_((ItemLike)ECBlocks.AIR_CRYSTAL_BLOCK.get());
        o.m_246326_((ItemLike)ECItems.PURE_CRYSTAL.get());
        o.m_246326_((ItemLike)ECItems.FIRE_SHARD.get());
        o.m_246326_((ItemLike)ECItems.WATER_SHARD.get());
        o.m_246326_((ItemLike)ECItems.EARTH_SHARD.get());
        o.m_246326_((ItemLike)ECItems.AIR_SHARD.get());
        o.m_246326_((ItemLike)ECItems.POWERFUL_FIRE_SHARD.get());
        o.m_246326_((ItemLike)ECItems.POWERFUL_WATER_SHARD.get());
        o.m_246326_((ItemLike)ECItems.POWERFUL_EARTH_SHARD.get());
        o.m_246326_((ItemLike)ECItems.POWERFUL_AIR_SHARD.get());
        o.m_246326_((ItemLike)ECItems.CRUDE_FIRE_GEM.get());
        o.m_246326_((ItemLike)ECItems.CRUDE_WATER_GEM.get());
        o.m_246326_((ItemLike)ECItems.CRUDE_EARTH_GEM.get());
        o.m_246326_((ItemLike)ECItems.CRUDE_AIR_GEM.get());
        o.m_246326_((ItemLike)ECItems.FINE_FIRE_GEM.get());
        o.m_246326_((ItemLike)ECItems.FINE_WATER_GEM.get());
        o.m_246326_((ItemLike)ECItems.FINE_EARTH_GEM.get());
        o.m_246326_((ItemLike)ECItems.FINE_AIR_GEM.get());
        o.m_246326_((ItemLike)ECItems.PRISTINE_FIRE_GEM.get());
        o.m_246326_((ItemLike)ECItems.PRISTINE_WATER_GEM.get());
        o.m_246326_((ItemLike)ECItems.PRISTINE_EARTH_GEM.get());
        o.m_246326_((ItemLike)ECItems.PRISTINE_AIR_GEM.get());
        o.m_246326_((ItemLike)ECItems.DRENCHED_IRON_NUGGET.get());
        o.m_246326_((ItemLike)ECItems.DRENCHED_IRON_INGOT.get());
        o.m_246326_((ItemLike)ECBlocks.DRENCHED_IRON_BLOCK.get());
        o.m_246326_((ItemLike)ECItems.SWIFT_ALLOY_NUGGET.get());
        o.m_246326_((ItemLike)ECItems.SWIFT_ALLOY_INGOT.get());
        o.m_246326_((ItemLike)ECBlocks.SWIFT_ALLOY_BLOCK.get());
        o.m_246326_((ItemLike)ECItems.FIREITE_NUGGET.get());
        o.m_246326_((ItemLike)ECItems.FIREITE_INGOT.get());
        o.m_246326_((ItemLike)ECBlocks.FIREITE_BLOCK.get());
        o.m_246326_((ItemLike)ECItems.SPRINGALINE_SHARD.get());
        o.m_246326_((ItemLike)ECBlocks.SPRINGALINE_BLOCK.get());
        o.m_246326_((ItemLike)ECBlocks.SMALL_SPRINGALINE_BUD.get());
        o.m_246326_((ItemLike)ECBlocks.MEDIUM_SPRINGALINE_BUD.get());
        o.m_246326_((ItemLike)ECBlocks.LARGE_SPRINGALINE_BUD.get());
        o.m_246326_((ItemLike)ECBlocks.SPRINGALINE_CLUSTER.get());
        o.m_246326_((ItemLike)ECBlocks.SPRINGALINE_GLASS.get());
        o.m_246326_((ItemLike)ECBlocks.SPRINGALINE_GLASS_PANE.get());
        o.m_246326_((ItemLike)ECBlocks.SPRINGALINE_LANTERN.get());
        o.m_246326_((ItemLike)ECItems.SOLAR_PRISM.get());
        o.m_246326_((ItemLike)ECItems.FIRE_LENS.get());
        o.m_246326_((ItemLike)ECItems.WATER_LENS.get());
        o.m_246326_((ItemLike)ECItems.EARTH_LENS.get());
        o.m_246326_((ItemLike)ECItems.AIR_LENS.get());
        o.m_246326_((ItemLike)ECItems.AIR_SILK.get());
        o.m_246326_((ItemLike)ECItems.HARDENED_HANDLE.get());
        o.m_246326_((ItemLike)ECItems.DRENCHED_SAW_BLADE.get());
        o.m_246326_((ItemLike)ECItems.SCROLL_PAPER.get());
        o.m_246326_((ItemLike)ECItems.SHRINE_BASE.get());
        o.m_246326_((ItemLike)ECItems.SHRINE_UPGRADE_CORE.get());
        o.m_246326_((ItemLike)ECItems.MINOR_RUNE_SLATE.get());
        o.m_246326_((ItemLike)ECItems.RUNE_SLATE.get());
        o.m_246326_((ItemLike)ECItems.MAJOR_RUNE_SLATE.get());
        ECCreativeModeTabs.generateRunes(o);
        o.m_246326_((ItemLike)ECItems.UNSET_JEWEL.get());
        ECCreativeModeTabs.generateJewels(o);
    }).m_257652_());

    private static void generateElementopedia(@Nonnull CreativeModeTab.Output output) {
        ItemStack book = new ItemStack((ItemLike)ECItems.ELEMENTOPEDIA.get());
        book.m_41784_().m_128359_("patchouli:book", "elementalcraft:element_book");
        output.m_246342_(book);
    }

    private static void generateElementContainer(@Nonnull CreativeModeTab.Output output, @Nonnull Supplier<? extends AbstractElementContainerBlock> supplier) {
        List<ElementType> list;
        AbstractElementContainerBlock block = supplier.get();
        Item item = block.m_5456_();
        output.m_246342_(new ItemStack((ItemLike)item));
        if (block instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)((Object)block);
            list = List.of(provider.getElementType());
        } else {
            list = ElementType.ALL_VALID;
        }
        for (ElementType type : list) {
            ItemStack stack = new ItemStack((ItemLike)item);
            CompoundTag tag = stack.m_41698_("BlockEntityTag");
            tag.m_128365_("element_storage", (Tag)new SingleElementStorage(type, block.getDefaultCapacity(), block.getDefaultCapacity()).serializeNBT());
            output.m_246342_(stack);
        }
    }

    private static void generateElementHolder(@Nonnull CreativeModeTab.Output output, @Nonnull Supplier<? extends ElementHolderItem> supplier) {
        ElementHolderItem item = supplier.get();
        ItemStack full = new ItemStack((ItemLike)item);
        ISingleElementStorage storage = item.getElementStorage(full);
        storage.insertElement(item.getElementCapacity(), false);
        output.m_246342_(new ItemStack((ItemLike)item));
        output.m_246342_(full);
    }

    private static void generatePureElementHolder(@Nonnull CreativeModeTab.Output output) {
        PureElementHolderItem item = (PureElementHolderItem)ECItems.PURE_HOLDER.get();
        ItemStack full = new ItemStack((ItemLike)item);
        IElementStorage storage = item.getElementStorage(full);
        ElementType.ALL_VALID.forEach(elementType -> storage.insertElement(item.getElementCapacity(), (ElementType)elementType, false));
        output.m_246342_(new ItemStack((ItemLike)item));
        output.m_246342_(full);
    }

    private static void generateSpells(@Nonnull CreativeModeTab.Output output) {
        StreamSupport.stream(Spells.REGISTRY.get().spliterator(), false).filter(Spell::isVisible).map(s -> {
            ItemStack stack = new ItemStack((ItemLike)ECItems.SCROLL.get());
            SpellHelper.setSpell(stack, s);
            return stack;
        }).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
    }

    private static void generateReceptacles(@Nonnull CreativeModeTab.Output output) {
        ElementType.ALL_VALID.stream().map(ReceptacleHelper::create).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0));
    }

    private static void generatePureOres(@Nonnull CreativeModeTab.Output output) {
        ElementalCraft.PURE_ORE_MANAGER.getOres().forEach(id -> output.m_246342_(ElementalCraft.PURE_ORE_MANAGER.createPureOre((ResourceLocation)id)));
    }

    private static void generateRunes(@Nonnull CreativeModeTab.Output output) {
        RuneItem item = (RuneItem)ECItems.RUNE.get();
        ElementalCraftApi.RUNE_MANAGER.getData().forEach((l, r) -> output.m_246342_(item.getRuneStack((Rune)r)));
    }

    private static void generateJewels(@Nonnull CreativeModeTab.Output output) {
        JewelItem item = (JewelItem)((Object)ECItems.JEWEL.get());
        Jewels.REGISTRY.get().forEach(j -> output.m_246342_(item.getJewelStack((Jewel)j)));
    }

    private ECCreativeModeTabs() {
    }

    public static void register(IEventBus bus) {
        DEFERRED_REGISTER.register(bus);
    }
}

