/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.jei.ingredient.source;

import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.interaction.jei.ingredient.source.IngredientSource;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;

public class SourceIngredientHelper
implements IIngredientHelper<IngredientSource> {
    @Nonnull
    public String getDisplayName(IngredientSource ingredient) {
        return I18n.m_118938_((String)ingredient.getTranslationKey(), (Object[])new Object[0]);
    }

    @Nonnull
    public String getUniqueId(@Nonnull IngredientSource ingredient, @Nonnull UidContext context) {
        return this.getName(ingredient);
    }

    @Nonnull
    private String getName(IngredientSource ingredient) {
        return ingredient.getElementType().m_7912_() + "_source";
    }

    @Nonnull
    public ResourceLocation getResourceLocation(@Nonnull IngredientSource ingredient) {
        return ElementalCraft.createRL(this.getName(ingredient));
    }

    @Nonnull
    public IngredientSource copyIngredient(IngredientSource ingredient) {
        return ingredient.copy();
    }

    public boolean isValidIngredient(IngredientSource ingredient) {
        return ingredient.getElementType() != ElementType.NONE;
    }

    @Nonnull
    public String getErrorInfo(IngredientSource ingredient) {
        return ingredient != null && ingredient.getElementType() == ElementType.NONE ? "Element shouldn't be none" : "";
    }

    @Nonnull
    public IIngredientType<IngredientSource> getIngredientType() {
        return IngredientSource.TYPE;
    }

    @Nonnull
    public ItemStack getCheatItemStack(IngredientSource ingredient) {
        return ReceptacleHelper.create(ingredient.getElementType());
    }
}

