/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.interaction.ie.injector;

import blusunrize.immersiveengineering.api.crafting.IESerializableRecipe;
import blusunrize.immersiveengineering.common.crafting.GeneratedListRecipe;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftApi;
import sirttas.elementalcraft.api.pureore.injector.AbstractPureOreRecipeInjector;
import sirttas.elementalcraft.tag.ECTags;

public abstract class AbstractIEPureOreRecipeInjector<T extends IESerializableRecipe>
extends AbstractPureOreRecipeInjector<Container, IESerializableRecipe> {
    private final Class<T> recipeClass;

    protected AbstractIEPureOreRecipeInjector(Supplier<RecipeType<T>> recipeType, Class<T> recipeClass) {
        super(() -> (RecipeType)recipeType.get(), true);
        this.recipeClass = recipeClass;
    }

    @Override
    public final IESerializableRecipe build(@NotNull RegistryAccess registry, @NotNull IESerializableRecipe recipe, @NotNull Ingredient ingredient) {
        if (this.recipeClass.isInstance(recipe)) {
            return this.buildIERecipe((IESerializableRecipe)this.recipeClass.cast(recipe), ingredient);
        }
        if (recipe instanceof GeneratedListRecipe) {
            GeneratedListRecipe generatedListRecipe = (GeneratedListRecipe)recipe;
            return generatedListRecipe.getSubRecipes().stream().map(r -> this.build(registry, (IESerializableRecipe)r, ingredient)).filter(Objects::nonNull).findFirst().orElse(null);
        }
        return null;
    }

    protected abstract T buildIERecipe(T var1, Ingredient var2);

    @Override
    public final boolean filter(IESerializableRecipe recipe, ItemStack stack) {
        try {
            if (!stack.m_204117_(ECTags.Items.PURE_ORES_SOURCE_RAW_MATERIALS)) {
                return false;
            }
            if (this.recipeClass.isInstance(recipe)) {
                return this.filterIERecipe((IESerializableRecipe)this.recipeClass.cast(recipe), stack);
            }
            if (recipe instanceof GeneratedListRecipe) {
                GeneratedListRecipe generatedListRecipe = (GeneratedListRecipe)recipe;
                return generatedListRecipe.getSubRecipes().stream().anyMatch(r -> this.filter((IESerializableRecipe)r, stack));
            }
        }
        catch (Exception e) {
            ElementalCraftApi.LOGGER.warn("Error while filtering immersive engineering recipe {} for pure ore", (Object)recipe.m_6423_(), (Object)e);
        }
        return false;
    }

    protected abstract boolean filterIERecipe(T var1, ItemStack var2);
}

