/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.input;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sirttas.elementalcraft.input.ECKeyConflictContext;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="elementalcraft", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ECKeyMappings {
    public static final List<KeyMapping> CHANGE_TO_SPELL = List.of(ECKeyMappings.spellChangeKey(1), ECKeyMappings.spellChangeKey(2), ECKeyMappings.spellChangeKey(3), ECKeyMappings.spellChangeKey(4), ECKeyMappings.spellChangeKey(5), ECKeyMappings.spellChangeKey(6), ECKeyMappings.spellChangeKey(7), ECKeyMappings.spellChangeKey(8), ECKeyMappings.spellChangeKey(9), ECKeyMappings.spellChangeKey(0));

    private ECKeyMappings() {
    }

    private static KeyMapping key(String name, int keyCode) {
        return ECKeyMappings.key(name, (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, keyCode);
    }

    private static KeyMapping spellChangeKey(int number) {
        return ECKeyMappings.key("change_spell." + number, ECKeyConflictContext.CHANGE_SPELL, KeyModifier.SHIFT, 48 + number);
    }

    private static KeyMapping key(String name, IKeyConflictContext keyConflictContext, KeyModifier keyModifier, int keyCode) {
        return new KeyMapping("key.elementalcraft." + name, keyConflictContext, keyModifier, InputConstants.Type.KEYSYM.m_84895_(keyCode), "key.categories.elementalcraft");
    }

    @SubscribeEvent
    public static void registerKeyBinds(RegisterKeyMappingsEvent event) {
        for (KeyMapping key : CHANGE_TO_SPELL) {
            event.register(key);
        }
    }
}

