/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.gui.tooltip;

import javax.annotation.Nonnull;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.tooltip.ElementGaugeTooltip;
import sirttas.elementalcraft.gui.GuiHelper;

public record ElementGaugeClientTooltip(IElementStorage storage) implements ClientTooltipComponent
{
    public ElementGaugeClientTooltip(ElementGaugeTooltip tooltip) {
        this(tooltip.storage());
    }

    public int m_142103_() {
        return this.isValid() ? 18 : 0;
    }

    public int m_142069_(@Nonnull Font font) {
        if (!this.isValid()) {
            return 0;
        }
        return Math.max((int)(ElementType.ALL_VALID.stream().filter(elementType -> this.storage.getElementCapacity((ElementType)elementType) > 0).count() * 18L) - 2, 0);
    }

    public void m_183452_(@Nonnull Font font, int x, int y, @Nonnull GuiGraphics guiGraphics) {
        if (!this.isValid()) {
            return;
        }
        int i = 0;
        for (ElementType elementType : ElementType.ALL_VALID) {
            int elementCapacity = this.storage.getElementCapacity(elementType);
            int elementAmount = this.storage.getElementAmount(elementType);
            if (elementCapacity <= 0) continue;
            GuiHelper.renderElementGauge(guiGraphics, font, x + i++ * 18, y, elementAmount, elementCapacity, elementType, false);
        }
    }

    private boolean isValid() {
        IElementStorage iElementStorage = this.storage;
        if (iElementStorage instanceof IElementTypeProvider) {
            IElementTypeProvider provider = (IElementTypeProvider)((Object)iElementStorage);
            return provider.getElementType() != ElementType.NONE;
        }
        return this.storage != null;
    }
}

