/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source.breeder;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.apache.commons.lang3.BooleanUtils;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.ECBlocks;
import sirttas.elementalcraft.block.entity.renderer.SingleItemRenderer;
import sirttas.elementalcraft.block.source.SourceRendererHelper;
import sirttas.elementalcraft.block.source.breeder.SourceBreederBlockEntity;
import sirttas.elementalcraft.block.source.breeder.pedestal.SourceBreederPedestalBlock;
import sirttas.elementalcraft.config.ECConfig;
import sirttas.elementalcraft.item.ECItems;
import sirttas.elementalcraft.item.source.receptacle.ReceptacleHelper;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class SourceBreederRenderer
extends SingleItemRenderer<SourceBreederBlockEntity> {
    private final BlockState pedestalState = ((SourceBreederPedestalBlock)((Object)ECBlocks.SOURCE_BREEDER_PEDESTAL.get())).m_49966_();

    public SourceBreederRenderer() {
        super(new Vec3(0.5, 1.0, 0.5));
    }

    public void render(@Nonnull SourceBreederBlockEntity breeder, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        this.renderPedestalShadow(breeder, poseStack, buffer);
        ItemStack stack = breeder.getInventory().m_8020_(0);
        poseStack.m_252880_(0.0f, 1.0f, 0.0f);
        if (stack.m_150930_((Item)ECItems.RECEPTACLE.get())) {
            ECRendererHelper.renderRunes(poseStack, buffer, (ICapabilityProvider)breeder, partialTicks, light, overlay);
            ElementType type = ReceptacleHelper.getElementType(stack);
            if (type == ElementType.NONE) {
                return;
            }
            poseStack.m_252880_(0.0f, 1.0f, 0.0f);
            SourceRendererHelper.renderSource(poseStack, buffer, partialTicks, light, overlay, type, false, 1.0f);
            return;
        }
        super.m_6922_(breeder, partialTicks, poseStack, buffer, light, overlay);
    }

    private void renderPedestalShadow(@Nonnull SourceBreederBlockEntity breeder, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer) {
        List<Direction> directions;
        if (BooleanUtils.isTrue((Boolean)((Boolean)ECConfig.CLIENT.renderPedestalShadow.get())) && (directions = breeder.getPedestalsDirections()).size() < 2) {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                if (directions.contains(direction)) continue;
                poseStack.m_85836_();
                poseStack.m_85837_((double)direction.m_122429_() * 2.0, 0.0, (double)direction.m_122431_() * 2.0);
                ECRendererHelper.renderGhost(this.pedestalState, poseStack, buffer, breeder.m_58904_(), breeder.m_58899_().m_5484_(direction, 2));
                poseStack.m_85849_();
            }
        }
    }
}

