/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.source;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.single.ISingleElementStorage;
import sirttas.elementalcraft.api.source.trait.holder.ISourceTraitHolder;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.source.SourceElementStorage;
import sirttas.elementalcraft.block.source.SourceSourceTraitHolder;

public class SourceBlockEntity
extends AbstractECBlockEntity
implements IElementTypeProvider {
    private boolean analyzed = false;
    private boolean stabilized = false;
    private final SourceElementStorage elementStorage = new SourceElementStorage(this);
    private final SourceSourceTraitHolder traitHolder;

    public SourceBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.SOURCE, pos, state);
        this.elementStorage.setElementType(ElementType.getElementType(state));
        this.traitHolder = new SourceSourceTraitHolder(this);
    }

    @NotNull
    public ISingleElementStorage getElementStorage() {
        return this.elementStorage;
    }

    @NotNull
    public ISourceTraitHolder getTraitHolder() {
        return this.traitHolder;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SourceBlockEntity source) {
        if (source.traitHolder.isEmpty() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            source.initTraits((ServerLevelAccessor)serverLevel, 0);
        }
        if (source.elementStorage.isExhausted()) {
            if (source.traitHolder.isArtificial()) {
                level.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            } else {
                source.elementStorage.insertElement(source.traitHolder.getRecoverRate(), false);
            }
        }
    }

    private void initTraits(@Nonnull ServerLevelAccessor level, int luck) {
        if (this.elementStorage.getElementType() == ElementType.NONE) {
            this.elementStorage.setElementType(ElementType.getElementType(this.m_58900_()));
            this.m_6596_();
        }
        this.traitHolder.initTraits(level, this.f_58858_, luck);
        this.refreshCapacity();
    }

    public void resetTraits(@Nonnull ServerLevelAccessor level, int luck) {
        this.traitHolder.clear();
        this.initTraits(level, luck);
    }

    public boolean isExhausted() {
        return this.elementStorage.isExhausted();
    }

    public void exhaust() {
        if (!this.traitHolder.isArtificial()) {
            this.elementStorage.setElementAmount(0);
        }
    }

    @Override
    public ElementType getElementType() {
        return this.elementStorage.getElementType();
    }

    public float getRemainingRatio() {
        int capacity = this.elementStorage.getElementCapacity();
        if (capacity == 0) {
            return 0.0f;
        }
        return (float)this.elementStorage.getElementAmount() / (float)capacity;
    }

    public boolean isAnalyzed() {
        return this.analyzed;
    }

    public void setAnalyzed(boolean analyzed) {
        this.analyzed = analyzed;
        this.m_6596_();
    }

    public boolean isStabilized() {
        return this.stabilized;
    }

    public void setStabilized(boolean stabilized) {
        this.stabilized = stabilized;
        this.m_6596_();
    }

    private void refreshCapacity() {
        int oldCapacity = this.elementStorage.getElementCapacity();
        int capacity = this.traitHolder.getCapacity();
        int amount = this.elementStorage.getElementAmount();
        this.elementStorage.setElementCapacity(capacity);
        if (amount <= 0 || amount >= oldCapacity || amount >= capacity) {
            this.elementStorage.setElementAmount(capacity);
        }
        this.m_6596_();
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        if (compound.m_128441_("element_storage")) {
            this.elementStorage.deserializeNBT(compound.m_128469_("element_storage"));
        }
        this.analyzed = compound.m_128471_("analyzed");
        if (compound.m_128441_("traits_holder")) {
            this.traitHolder.deserializeNBT(compound.m_128469_("traits_holder"));
        }
        this.stabilized = compound.m_128471_("stabilized");
        this.elementStorage.setExhausted(compound.m_128471_("exhausted"));
        this.refreshCapacity();
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("element_storage", (Tag)this.elementStorage.serializeNBT());
        compound.m_128379_("exhausted", this.elementStorage.isExhausted());
        compound.m_128365_("traits_holder", (Tag)this.traitHolder.serializeNBT());
        compound.m_128379_("analyzed", this.analyzed);
        compound.m_128379_("stabilized", this.stabilized);
    }

    @Nonnull
    public <U> LazyOptional<U> getCapability(@Nonnull Capability<U> cap, @Nullable Direction side) {
        if (!this.f_58859_) {
            if (cap == ElementalCraftCapabilities.ELEMENT_STORAGE) {
                return LazyOptional.of(this::getElementStorage).cast();
            }
            if (cap == ElementalCraftCapabilities.SOURCE_TRAIT_HOLDER) {
                return LazyOptional.of(this::getTraitHolder).cast();
            }
        }
        return super.getCapability(cap, side);
    }
}

