/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.shrine.overload;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.shrine.AbstractShrineBlockEntity;
import sirttas.elementalcraft.block.shrine.overload.OverloadShrineBlock;
import sirttas.elementalcraft.block.shrine.properties.ShrineProperties;

public class OverloadShrineBlockEntity
extends AbstractShrineBlockEntity {
    public static final ResourceKey<ShrineProperties> PROPERTIES_KEY = OverloadShrineBlockEntity.createKey("overloadshrine");
    private TickingBlockEntity ticker;

    public OverloadShrineBlockEntity(BlockPos pos, BlockState state) {
        super(ECBlockEntityTypes.OVERLOAD_SHRINE, pos, state, PROPERTIES_KEY);
    }

    @Override
    public AABB getRange() {
        return new AABB(this.getTargetPos());
    }

    @Override
    public BlockPos getTargetPos() {
        return this.f_58858_.m_121945_((Direction)this.m_58900_().m_61143_((Property)OverloadShrineBlock.FACING));
    }

    @Override
    protected boolean doPeriod() {
        TickingBlockEntity t = this.getTicker();
        if (t != null) {
            t.m_142224_();
            return true;
        }
        return false;
    }

    private TickingBlockEntity getTicker() {
        if (this.ticker == null) {
            BlockPos target = this.getTargetPos();
            this.ticker = (TickingBlockEntity)this.f_58857_.m_46745_((BlockPos)target).f_156362_.get(target);
        }
        if (this.ticker == null || this.ticker.m_142220_() || this.f_58857_.m_7702_(this.ticker.m_142689_()) instanceof AbstractShrineBlockEntity) {
            this.ticker = null;
        }
        return this.ticker;
    }

    @Override
    public List<Direction> getUpgradeDirections() {
        return DEFAULT_UPGRADE_DIRECTIONS.stream().filter(direction -> direction != this.m_58900_().m_61143_((Property)OverloadShrineBlock.FACING)).collect(Collectors.toList());
    }
}

