/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pureinfuser.pedestal;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.block.AbstractECContainerBlock;
import sirttas.elementalcraft.block.pipe.IPipeConnectedBlock;
import sirttas.elementalcraft.block.pureinfuser.pedestal.PedestalBlockEntity;

public class PedestalBlock
extends AbstractECContainerBlock
implements IElementTypeProvider,
IPipeConnectedBlock {
    private static final VoxelShape BASE_1 = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BASE_2 = Block.m_49796_((double)2.0, (double)3.0, (double)2.0, (double)14.0, (double)9.0, (double)14.0);
    private static final VoxelShape BASE_3 = Block.m_49796_((double)0.0, (double)9.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    private static final VoxelShape CONNECTOR_NORTH = Block.m_49796_((double)7.0, (double)7.0, (double)0.0, (double)9.0, (double)9.0, (double)2.0);
    private static final VoxelShape CONNECTOR_SOUTH = Block.m_49796_((double)7.0, (double)7.0, (double)14.0, (double)9.0, (double)9.0, (double)16.0);
    private static final VoxelShape CONNECTOR_WEST = Block.m_49796_((double)0.0, (double)7.0, (double)7.0, (double)2.0, (double)9.0, (double)9.0);
    private static final VoxelShape CONNECTOR_EAST = Block.m_49796_((double)14.0, (double)7.0, (double)7.0, (double)16.0, (double)9.0, (double)9.0);
    private static final VoxelShape BASE = Shapes.m_83124_((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3});
    private static final VoxelShape AIR = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)3.0, (double)11.0), (VoxelShape[])new VoxelShape[]{BASE_2, BASE_3});
    private static final VoxelShape EARTH = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)4.0, (double)3.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0), Block.m_49796_((double)0.0, (double)3.0, (double)4.0, (double)16.0, (double)8.0, (double)12.0)});
    public static final String NAME = "pedestal";
    public static final String NAME_FIRE = "pedestal_fire";
    public static final String NAME_WATER = "pedestal_water";
    public static final String NAME_EARTH = "pedestal_earth";
    public static final String NAME_AIR = "pedestal_air";
    private final ElementType elementType;

    public PedestalBlock(ElementType type) {
        this.elementType = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false)));
    }

    public PedestalBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return this.getElementType() != ElementType.NONE ? new PedestalBlockEntity(pos, state) : null;
    }

    @Nonnull
    @Deprecated
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        return this.onSingleSlotActivated(world, pos, player, hand);
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        VoxelShape shape = this.getBaseShape();
        if (Boolean.TRUE.equals(state.m_61143_((Property)NORTH))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECTOR_NORTH);
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)SOUTH))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECTOR_SOUTH);
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)EAST))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECTOR_EAST);
        }
        if (Boolean.TRUE.equals(state.m_61143_((Property)WEST))) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)CONNECTOR_WEST);
        }
        return shape;
    }

    private VoxelShape getBaseShape() {
        if (this.elementType == ElementType.AIR) {
            return AIR;
        }
        if (this.elementType == ElementType.EARTH) {
            return EARTH;
        }
        return BASE;
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{NORTH, SOUTH, EAST, WEST});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return this.doGetStateForPlacement((BlockGetter)context.m_43725_(), context.m_8083_());
    }

    @Nonnull
    @Deprecated
    public BlockState m_7417_(@Nonnull BlockState stateIn, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor worldIn, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        return this.doUpdateShape(stateIn, (BlockGetter)worldIn, currentPos, facing);
    }
}

