/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade.beam;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.resources.ResourceLocation;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.upgrade.beam.ElementBeamPipeUpgrade;
import sirttas.elementalcraft.block.pipe.upgrade.renderer.IPipeUpgradeRenderer;
import sirttas.elementalcraft.renderer.ECRendererHelper;

public class ElementBeamPipeUpgradeRenderer
implements IPipeUpgradeRenderer<ElementBeamPipeUpgrade> {
    public static final ResourceLocation RING_1_LOCATION = ElementalCraft.createRL("elementalcraft/pipe_upgrade/element_beam_ring_1");
    public static final ResourceLocation RING_2_LOCATION = ElementalCraft.createRL("elementalcraft/pipe_upgrade/element_beam_ring_2");
    public static final ResourceLocation RING_3_LOCATION = ElementalCraft.createRL("elementalcraft/pipe_upgrade/element_beam_ring_3");
    private BakedModel ring1Model;
    private BakedModel ring2Model;
    private BakedModel ring3Model;

    @Override
    public void render(ElementBeamPipeUpgrade upgrade, ElementPipeBlockEntity pipe, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (this.ring1Model == null || this.ring2Model == null || this.ring3Model == null) {
            ModelManager modelManager = Minecraft.m_91087_().m_91304_();
            this.ring1Model = modelManager.getModel(RING_1_LOCATION);
            this.ring2Model = modelManager.getModel(RING_2_LOCATION);
            this.ring3Model = modelManager.getModel(RING_3_LOCATION);
        }
        if (!upgrade.isLinked()) {
            ECRendererHelper.renderModel(this.ring1Model, poseStack, buffer, pipe, light, overlay);
            ECRendererHelper.renderModel(this.ring2Model, poseStack, buffer, pipe, light, overlay);
            ECRendererHelper.renderModel(this.ring3Model, poseStack, buffer, pipe, light, overlay);
        } else {
            float tick = ECRendererHelper.getClientTicks(partialTicks) % 50.0f;
            poseStack.m_85836_();
            ElementBeamPipeUpgradeRenderer.translateRing(tick, 0, 5, 20, 30, poseStack);
            ECRendererHelper.renderModel(this.ring1Model, poseStack, buffer, pipe, light, overlay);
            poseStack.m_85849_();
            poseStack.m_85836_();
            ElementBeamPipeUpgradeRenderer.translateRing(tick, 5, 10, 25, 35, poseStack);
            ECRendererHelper.renderModel(this.ring2Model, poseStack, buffer, pipe, light, overlay);
            poseStack.m_85849_();
            poseStack.m_85836_();
            ElementBeamPipeUpgradeRenderer.translateRing(tick, 10, 15, 30, 40, poseStack);
            ECRendererHelper.renderModel(this.ring3Model, poseStack, buffer, pipe, light, overlay);
            poseStack.m_85849_();
        }
    }

    private static void translateRing(float tick, int from, int to, int from2, int to2, @Nonnull PoseStack poseStack) {
        if (tick < (float)to && tick >= (float)from) {
            poseStack.m_252880_(0.0f, ((float)from - tick) / 100.0f, 0.0f);
        } else if (tick >= (float)to && tick < (float)from2) {
            poseStack.m_252880_(0.0f, -0.05f, 0.0f);
        } else if (tick >= (float)from2 && tick < (float)to2) {
            poseStack.m_252880_(0.0f, -0.05f + (tick - (float)from2) / 200.0f, 0.0f);
        }
    }
}

