/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe.upgrade;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Containers;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlockEntity;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;
import sirttas.elementalcraft.block.pipe.upgrade.type.PipeUpgradeType;
import sirttas.elementalcraft.loot.parameter.ECLootContextParamSets;
import sirttas.elementalcraft.loot.parameter.ECLootContextParams;

public class PipeUpgrade
extends CapabilityProvider<PipeUpgrade>
implements ItemLike {
    public static final String FOLDER = "elementalcraft/pipe_upgrade/";
    private final PipeUpgradeType<?> type;
    private final ElementPipeBlockEntity pipe;
    private final Direction direction;
    private Item item;

    protected PipeUpgrade(PipeUpgradeType<?> type, ElementPipeBlockEntity pipe, Direction direction) {
        super(PipeUpgrade.class);
        this.type = type;
        this.pipe = pipe;
        this.direction = direction;
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        return side == null || side == this.direction ? super.getCapability(cap, side) : LazyOptional.empty();
    }

    public ResourceLocation getKey() {
        return this.type.getKey();
    }

    public void load(CompoundTag tag) {
        if (this.getCapabilities() != null && tag.m_128441_("ForgeCaps")) {
            this.deserializeCaps(tag.m_128469_("ForgeCaps"));
        }
    }

    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        tag.m_128359_("id", this.getKey().toString());
        this.saveAdditional(tag);
        return tag;
    }

    protected void saveAdditional(CompoundTag tag) {
        CompoundTag caps;
        if (this.getCapabilities() != null && (caps = this.serializeCaps()) != null) {
            tag.m_128365_("ForgeCaps", (Tag)caps);
        }
    }

    @Nonnull
    public PipeUpgradeType<?> getType() {
        return this.type;
    }

    @Nonnull
    public Direction getDirection() {
        return this.direction;
    }

    @Nonnull
    public ElementPipeBlockEntity getPipe() {
        return this.pipe;
    }

    public void onAdded() {
    }

    public void onRemoved() {
    }

    public void onTransfer(ElementType type, int amount, @Nullable BlockPos from, @Nullable BlockPos to) {
    }

    public boolean canPlace(ConnectionType connectionType) {
        return connectionType.isConnected();
    }

    public boolean canTransfer(ElementType type, ConnectionType connection) {
        return true;
    }

    public VoxelShape getShape() {
        return Shapes.m_83040_();
    }

    public boolean replaceSection() {
        return false;
    }

    public boolean replaceExtraction() {
        return this.replaceSection();
    }

    public List<BlockPos> getConnections(ElementType type, ConnectionType connection) {
        return this.canTransfer(type, connection) ? ElementPipeTransferer.getDefaultPos(this.pipe.m_58899_(), this.direction, connection) : Collections.emptyList();
    }

    public IElementTransferPath alterPath(@Nonnull IElementTransferPath path) {
        return path;
    }

    @Nonnull
    public RenderShape getRenderShape() {
        return RenderShape.MODEL;
    }

    public void dropAll(@Nullable Player player) {
        ServerLevel serverLevel;
        block5: {
            block4: {
                Level level = this.pipe.m_58904_();
                if (!(level instanceof ServerLevel)) break block4;
                serverLevel = (ServerLevel)level;
                if (!serverLevel.f_46443_) break block5;
            }
            return;
        }
        ResourceLocation registryName = this.getKey();
        ResourceLocation tableLocation = new ResourceLocation(registryName.m_135827_(), FOLDER + registryName.m_135815_());
        if (tableLocation.equals((Object)BuiltInLootTables.f_78712_)) {
            return;
        }
        LootParams lootParams = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81461_, (Object)this.pipe.m_58900_()).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)this.pipe.m_58899_())).m_287286_(ECLootContextParams.DIRECTION, (Object)this.direction).m_287289_(LootContextParams.f_81455_, (Object)player).m_287289_(LootContextParams.f_81462_, (Object)this.pipe).m_287235_(ECLootContextParamSets.PIPE_UPGRADE);
        serverLevel.m_7654_().m_278653_().m_278676_(tableLocation).m_287195_(lootParams).forEach(player != null ? arg_0 -> ((Player)player).m_19983_(arg_0) : stack -> Containers.m_18992_((Level)serverLevel, (double)this.pipe.m_58899_().m_123341_(), (double)this.pipe.m_58899_().m_123342_(), (double)this.pipe.m_58899_().m_123343_(), (ItemStack)stack));
    }

    @Nonnull
    public Item m_5456_() {
        if (this.item == null) {
            this.item = this.type.m_5456_();
        }
        return this.item;
    }
}

