/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import sirttas.elementalcraft.api.element.transfer.ElementTransfererHelper;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;

public interface IPipeConnectedBlock {
    public static final BooleanProperty NORTH = BlockStateProperties.f_61368_;
    public static final BooleanProperty EAST = BlockStateProperties.f_61369_;
    public static final BooleanProperty SOUTH = BlockStateProperties.f_61370_;
    public static final BooleanProperty WEST = BlockStateProperties.f_61371_;

    default public BlockState doGetStateForPlacement(BlockGetter level, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((Block)this).m_49966_().m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.SOUTH)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.EAST)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.WEST)));
    }

    default public BlockState doUpdateShape(BlockState state, BlockGetter level, BlockPos pos, Direction facing) {
        return switch (facing) {
            case Direction.NORTH -> (BlockState)state.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.NORTH)));
            case Direction.SOUTH -> (BlockState)state.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.SOUTH)));
            case Direction.EAST -> (BlockState)state.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.EAST)));
            case Direction.WEST -> (BlockState)state.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(IPipeConnectedBlock.isConnectable(level, pos, Direction.WEST)));
            default -> state;
        };
    }

    public static boolean isConnectable(BlockGetter level, BlockPos from, Direction face) {
        Direction opposite = face.m_122424_();
        IElementTransferer transferer = BlockEntityHelper.getBlockEntity(level, from.m_121945_(face)).flatMap(b -> ElementTransfererHelper.get((ICapabilityProvider)b, opposite).resolve()).orElse(null);
        if (transferer instanceof ElementPipeTransferer) {
            ElementPipeTransferer elementPipeTransferer = (ElementPipeTransferer)transferer;
            ConnectionType connection = elementPipeTransferer.getConnection(opposite);
            return connection.isConnected() || connection == ConnectionType.NONE;
        }
        return false;
    }
}

