/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.pipe;

import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import sirttas.elementalcraft.api.ElementalCraftCapabilities;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.api.element.IElementTypeProvider;
import sirttas.elementalcraft.api.element.storage.ElementStorageHelper;
import sirttas.elementalcraft.api.element.storage.IElementStorage;
import sirttas.elementalcraft.api.element.transfer.ElementTransfererHelper;
import sirttas.elementalcraft.api.element.transfer.IElementTransferer;
import sirttas.elementalcraft.api.element.transfer.path.IElementTransferPath;
import sirttas.elementalcraft.api.element.transfer.path.SimpleElementTransferPathfinder;
import sirttas.elementalcraft.block.entity.AbstractECBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.block.pipe.ConnectionType;
import sirttas.elementalcraft.block.pipe.ElementPipeBlock;
import sirttas.elementalcraft.block.pipe.ElementPipeShapes;
import sirttas.elementalcraft.block.pipe.ElementPipeTransferer;
import sirttas.elementalcraft.block.pipe.upgrade.PipeUpgrade;

public class ElementPipeBlockEntity
extends AbstractECBlockEntity {
    private final ElementPipeTransferer transferer = new ElementPipeTransferer(this);
    private BlockState coverState;
    private final Map<Direction, IElementTransferPath> pathMap = new EnumMap<Direction, IElementTransferPath>(Direction.class);

    public ElementPipeBlockEntity(BlockPos pos, BlockState state) {
        super((Supplier<? extends BlockEntityType<?>>)ECBlockEntityTypes.PIPE, pos, state);
        this.coverState = Blocks.f_50016_.m_49966_();
    }

    private Optional<BlockEntity> getAdjacentTile(Direction face) {
        return this.m_58898_() ? BlockEntityHelper.getBlockEntity((BlockGetter)this.m_58904_(), this.m_58899_().m_121945_(face)) : Optional.empty();
    }

    public ConnectionType getConnection(Direction face) {
        return this.transferer.getConnection(face);
    }

    public VoxelShape getShape(@Nullable Direction face) {
        if (face == null) {
            return ElementPipeShapes.BASE_SHAPE;
        }
        ConnectionType connexion = this.transferer.getConnection(face);
        VoxelShape shape = Shapes.m_83040_();
        PipeUpgrade upgrade = this.transferer.getUpgrade(face);
        if (upgrade != null) {
            shape = upgrade.getShape();
        }
        if (connexion.isConnected()) {
            if (upgrade == null || !upgrade.replaceSection()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)ElementPipeShapes.SECTION_SHAPES.get(face));
            }
            if (!(connexion != ConnectionType.EXTRACT || upgrade != null && upgrade.replaceExtraction())) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)ElementPipeShapes.EXTRACTION_SHAPES.get(face));
            }
        }
        return shape;
    }

    public VoxelShape getShape() {
        VoxelShape shape = ElementPipeShapes.BASE_SHAPE;
        for (Direction face : Direction.values()) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)this.getShape(face));
        }
        return shape;
    }

    private void setConnection(Direction face, ConnectionType type) {
        if (this.transferer.getConnection(face) == type) {
            return;
        }
        this.transferer.setConnection(face, type);
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.m_58900_().m_60701_((LevelAccessor)this.f_58857_, this.m_58899_(), 3);
        }
    }

    private void refresh(Direction face) {
        Direction opposite = face.m_122424_();
        ConnectionType connection = this.getAdjacentTile(face).map(be -> {
            ConnectionType c = this.getConnection(face);
            if (c != ConnectionType.NONE) {
                return c;
            }
            if (ElementTransfererHelper.get((ICapabilityProvider)be, opposite).filter(t -> t.canConnectTo(this.m_58899_())).isPresent()) {
                return ConnectionType.CONNECT;
            }
            return ElementStorageHelper.get((ICapabilityProvider)be, opposite).map(storage -> {
                if (this.canInsertInStorage((IElementStorage)storage, opposite)) {
                    return ConnectionType.INSERT;
                }
                if (this.canExtractFromStorage((IElementStorage)storage, opposite)) {
                    return ConnectionType.EXTRACT;
                }
                return ConnectionType.NONE;
            }).orElse(ConnectionType.NONE);
        }).orElse(ConnectionType.NONE);
        this.setConnection(face, connection);
        PipeUpgrade upgrade = this.transferer.getUpgrade(face);
        if (upgrade != null && !upgrade.canPlace(connection)) {
            this.removeUpgrade(face);
        }
    }

    void refresh() {
        for (Direction face : Direction.values()) {
            this.refresh(face);
        }
    }

    Map<Direction, IElementTransferPath> getPathMap() {
        return this.pathMap;
    }

    private void transferElement(IElementStorage sender, Direction side, ElementType type) {
        BlockPos pos = this.m_58899_();
        if (type != ElementType.NONE && this.f_58857_ != null) {
            PipeUpgrade upgrade = this.transferer.getUpgrade(side);
            if (upgrade != null && !upgrade.canTransfer(type, ConnectionType.EXTRACT) || !this.canExtractFromStorage(sender, side.m_122424_())) {
                return;
            }
            SimpleElementTransferPathfinder pathfinder = new SimpleElementTransferPathfinder(this.f_58857_);
            IElementTransferPath path = pathfinder.findPath(type, new ElementPipeTransferer.Node(pos.m_121945_(side), null, sender), new ElementPipeTransferer.Node(pos, this.transferer, null));
            this.pathMap.put(side, path);
            if (upgrade != null) {
                path = upgrade.alterPath(path);
            }
            path.transfer();
        }
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, ElementPipeBlockEntity pipe) {
        pipe.refresh();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, ElementPipeBlockEntity pipe) {
        pipe.transferer.init();
        ElementPipeBlockEntity.commonTick(level, pos, state, pipe);
        pipe.transferer.getConnections().entrySet().stream().filter(entry -> entry.getValue() == ConnectionType.EXTRACT).sorted(pipe.transferer.comparator).map(Map.Entry::getKey).forEach(side -> pipe.getAdjacentTile((Direction)side).flatMap(tile -> ElementStorageHelper.get((ICapabilityProvider)tile, side.m_122424_()).resolve()).ifPresent(sender -> {
            if (sender instanceof IElementTypeProvider) {
                IElementTypeProvider provider = (IElementTypeProvider)((Object)sender);
                pipe.transferElement((IElementStorage)sender, (Direction)side, provider.getElementType());
            }
        }));
    }

    public IElementTransferer getTransferer() {
        return this.transferer;
    }

    public Map<Direction, PipeUpgrade> getUpgrades() {
        return this.transferer.getUpgrades();
    }

    public PipeUpgrade getUpgrade(Direction face) {
        return this.transferer.getUpgrade(face);
    }

    public void setUpgrade(Direction face, PipeUpgrade upgrade) {
        this.transferer.setUpgrade(face, Objects.requireNonNull(upgrade));
        upgrade.onAdded();
    }

    private void removeUpgrade(Direction side) {
        this.removeUpgrade(null, side);
    }

    private void removeUpgrade(@Nullable Player player, Direction side) {
        PipeUpgrade upgrade = this.getUpgrade(side);
        if (upgrade == null) {
            return;
        }
        upgrade.dropAll(player);
        this.transferer.removeUpgrade(side);
        upgrade.onRemoved();
    }

    void removeAllUpgrades() {
        for (Direction side : Direction.values()) {
            this.removeUpgrade(side);
        }
    }

    public InteractionResult activatePipe(@Nullable Player player, Direction face) {
        PipeUpgrade upgrade = this.getUpgrade(face);
        if (upgrade != null) {
            this.removeUpgrade(player, face);
            return InteractionResult.SUCCESS;
        }
        Direction opposite = face.m_122424_();
        return this.getAdjacentTile(face).map(tile -> {
            ConnectionType connection = this.getConnection(face);
            switch (connection) {
                case INSERT: {
                    if (ElementStorageHelper.get((ICapabilityProvider)tile, opposite).filter(storage -> this.canExtractFromStorage((IElementStorage)storage, opposite)).isPresent()) {
                        this.setConnection(face, ConnectionType.EXTRACT);
                    } else {
                        this.setConnection(face, ConnectionType.DISCONNECT);
                    }
                    return InteractionResult.SUCCESS;
                }
                case EXTRACT: 
                case CONNECT: {
                    this.setConnection(face, ConnectionType.DISCONNECT);
                    if (tile instanceof ElementPipeBlockEntity) {
                        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)((Object)tile);
                        pipe.setConnection(face.m_122424_(), ConnectionType.DISCONNECT);
                    }
                    return InteractionResult.SUCCESS;
                }
                case DISCONNECT: {
                    LazyOptional<IElementStorage> cap = ElementStorageHelper.get((ICapabilityProvider)tile, face.m_122424_());
                    if (cap.filter(storage -> this.canInsertInStorage((IElementStorage)storage, opposite)).isPresent()) {
                        this.setConnection(face, ConnectionType.INSERT);
                    } else if (cap.filter(storage -> this.canExtractFromStorage((IElementStorage)storage, opposite)).isPresent()) {
                        this.setConnection(face, ConnectionType.EXTRACT);
                    } else if (tile instanceof ElementPipeBlockEntity) {
                        ElementPipeBlockEntity pipe = (ElementPipeBlockEntity)((Object)tile);
                        this.setConnection(face, ConnectionType.CONNECT);
                        pipe.setConnection(face.m_122424_(), ConnectionType.CONNECT);
                    }
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }).orElse(InteractionResult.PASS);
    }

    private boolean canInsertInStorage(IElementStorage storage, Direction face) {
        return ElementType.ALL_VALID.stream().anyMatch(type -> storage.canPipeInsert((ElementType)type, face));
    }

    private boolean canExtractFromStorage(IElementStorage storage, Direction face) {
        return ElementType.ALL_VALID.stream().anyMatch(type -> storage.canPipeExtract((ElementType)type, face));
    }

    public Component getConnectionMessage(Direction face) {
        return this.getConnection(face).getDisplayName();
    }

    public BlockState getCoverState() {
        return this.coverState;
    }

    public boolean isCovered() {
        return !this.coverState.m_60795_();
    }

    public int getMaxTransferAmount() {
        return this.transferer.maxTransferAmount;
    }

    public InteractionResult setCover(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            BlockState state;
            BlockItem blockItem = (BlockItem)item;
            if (!stack.m_41619_() && (state = blockItem.m_40614_().m_49966_()) != this.coverState) {
                if (!this.coverState.m_60795_()) {
                    Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)new ItemStack((ItemLike)this.coverState.m_60734_()));
                }
                this.coverState = state;
                this.m_58904_().m_46597_(this.m_58899_(), (BlockState)this.m_58904_().m_8055_(this.f_58858_).m_61124_(ElementPipeBlock.COVER, (Comparable)((Object)ElementPipeBlock.CoverType.COVERED)));
                if (!player.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                    if (stack.m_41619_()) {
                        player.m_21008_(hand, ItemStack.f_41583_);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_142466_(@NotNull CompoundTag compound) {
        super.m_142466_(compound);
        this.transferer.load(compound.m_128469_("transferer"));
        HolderLookup.RegistryLookup blockGetter = this.f_58857_ != null ? this.f_58857_.m_246945_(Registries.f_256747_) : BuiltInRegistries.f_256975_.m_255303_();
        this.coverState = compound.m_128441_("cover") ? NbtUtils.m_247651_((HolderGetter)blockGetter, (CompoundTag)compound.m_128469_("cover")) : Blocks.f_50016_.m_49966_();
    }

    public void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("transferer", (Tag)this.transferer.save(new CompoundTag()));
        if (!this.coverState.m_60795_()) {
            compound.m_128365_("cover", (Tag)NbtUtils.m_129202_((BlockState)this.coverState));
        } else if (compound.m_128441_("cover")) {
            compound.m_128473_("cover");
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_) {
            PipeUpgrade upgrade;
            if (cap == ElementalCraftCapabilities.ELEMENT_TRANSFERER) {
                return LazyOptional.of(this::getTransferer).cast();
            }
            if (side != null && (upgrade = this.getUpgrade(side)) != null) {
                return upgrade.getCapability(cap, side);
            }
        }
        return super.getCapability(cap, side);
    }
}

