/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.mill;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.ElementalCraft;
import sirttas.elementalcraft.block.entity.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.instrument.AbstractInstrumentBlockEntity;
import sirttas.elementalcraft.block.instrument.io.mill.AbstractMillBlock;
import sirttas.elementalcraft.block.instrument.io.mill.AbstractMillBlockEntity;
import sirttas.elementalcraft.renderer.ECRendererHelper;

@OnlyIn(value=Dist.CLIENT)
public class MillRenderer<T extends AbstractMillBlockEntity<?, ?>>
implements BlockEntityRenderer<T> {
    public static final ResourceLocation WATER_MILL_GRINDSTONE_SHAFT_LOCATION = ElementalCraft.createRL("block/water_mill_grindstone_shaft");
    public static final ResourceLocation AIR_MILL_GRINDSTONE_SHAFT_LOCATION = ElementalCraft.createRL("block/air_mill_grindstone_shaft");
    public static final ResourceLocation WATER_MILL_WOOD_SAW_SHAFT_LOCATION = ElementalCraft.createRL("block/water_mill_wood_saw_shaft");
    public static final ResourceLocation AIR_MILL_WOOD_SAW_SHAFT_LOCATION = ElementalCraft.createRL("block/air_mill_wood_saw_shaft");
    private final ResourceLocation modelLocation;
    private BakedModel model;

    public MillRenderer(ResourceLocation modelLocation) {
        this.modelLocation = modelLocation;
    }

    public void render(@Nonnull T te, float partialTicks, @Nonnull PoseStack matrixStack, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (this.model == null && this.modelLocation != null) {
            this.model = Minecraft.m_91087_().m_91304_().getModel(this.modelLocation);
        }
        Container inv = ((AbstractMillBlockEntity)te).getInventory();
        ItemStack stack = inv.m_8020_(0);
        ItemStack stack2 = inv.m_8020_(1);
        float tick = ECRendererHelper.getClientTicks(partialTicks);
        ECRendererHelper.renderRunes(matrixStack, buffer, ((AbstractECCraftingBlockEntity)te).getRuneHandler(), tick, light, overlay);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.25, 0.0);
        if (((AbstractInstrumentBlockEntity)te).isRunning()) {
            matrixStack.m_85837_(0.5, 0.0, 0.5);
            matrixStack.m_252781_(Axis.f_252436_.m_252977_(-5.0f * tick));
            matrixStack.m_85837_(-0.5, 0.0, -0.5);
        }
        ECRendererHelper.renderModel(this.model, matrixStack, buffer, te, light, overlay);
        matrixStack.m_85849_();
        if (!stack.m_41619_() || !stack2.m_41619_()) {
            matrixStack.m_85837_(0.5, 0.3, 0.5);
            matrixStack.m_252781_(ECRendererHelper.getRotation((Direction)te.m_58900_().m_61143_((Property)AbstractMillBlock.FACING)));
            matrixStack.m_85837_(0.0, 0.0, -0.375);
            if (!stack.m_41619_()) {
                matrixStack.m_85836_();
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(tick));
                ECRendererHelper.renderItem(stack, matrixStack, buffer, light, overlay);
                matrixStack.m_85849_();
            }
            if (!stack2.m_41619_()) {
                matrixStack.m_85837_(0.0, 0.0, 0.75);
                matrixStack.m_252781_(Axis.f_252436_.m_252977_(tick));
                ECRendererHelper.renderItem(stack2, matrixStack, buffer, light, overlay);
            }
        }
    }
}

