/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.instrument.io.mill;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import sirttas.elementalcraft.api.element.ElementType;
import sirttas.elementalcraft.block.entity.AbstractECCraftingBlockEntity;
import sirttas.elementalcraft.block.instrument.IInstrument;
import sirttas.elementalcraft.block.instrument.io.AbstractIOInstrumentBlockEntity;
import sirttas.elementalcraft.container.IOContainer;
import sirttas.elementalcraft.recipe.instrument.io.IIOInstrumentRecipe;

public abstract class AbstractMillBlockEntity<T extends IInstrument, R extends IIOInstrumentRecipe<T>>
extends AbstractIOInstrumentBlockEntity<T, R> {
    private final ElementType elementType;
    private final IOContainer inventory = new IOContainer(this::m_6596_);

    protected AbstractMillBlockEntity(AbstractECCraftingBlockEntity.Config<T, R> config, ElementType elementType, BlockPos pos, BlockState state) {
        super(config, pos, state);
        this.elementType = elementType;
    }

    @Override
    @Nonnull
    protected IItemHandler createHandler() {
        return new SidedInvWrapper((WorldlyContainer)this.inventory, null);
    }

    @Override
    @Nonnull
    public Container getInventory() {
        return this.inventory;
    }

    @Override
    protected ElementType getRecipeElementType() {
        return this.recipe == null ? ElementType.NONE : this.elementType;
    }

    @Override
    public boolean isRecipeAvailable() {
        return this.getContainerElementType() == this.elementType && super.isRecipeAvailable();
    }

    @Override
    public ElementType getElementType() {
        return this.elementType;
    }
}

