/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.diffuser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sirttas.elementalcraft.block.AbstractECEntityBlock;
import sirttas.elementalcraft.block.diffuser.DiffuserBlockEntity;
import sirttas.elementalcraft.block.entity.BlockEntityHelper;
import sirttas.elementalcraft.block.entity.ECBlockEntityTypes;
import sirttas.elementalcraft.particle.ParticleHelper;

public class DiffuserBlock
extends AbstractECEntityBlock {
    public static final String NAME = "diffuser";
    private static final VoxelShape BASE_1 = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    private static final VoxelShape BASE_2 = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape PILLAR = Block.m_49796_((double)7.0, (double)4.0, (double)7.0, (double)9.0, (double)11.0, (double)9.0);
    private static final VoxelShape SIDE_PILLAR_1 = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)3.0, (double)6.0, (double)3.0);
    private static final VoxelShape SIDE_PILLAR_2 = SIDE_PILLAR_1.m_83216_(0.75, 0.0, 0.0);
    private static final VoxelShape SIDE_PILLAR_3 = SIDE_PILLAR_1.m_83216_(0.0, 0.0, 0.75);
    private static final VoxelShape SIDE_PILLAR_4 = SIDE_PILLAR_1.m_83216_(0.75, 0.0, 0.75);
    private static final VoxelShape SHAPE = Shapes.m_83124_((VoxelShape)BASE_1, (VoxelShape[])new VoxelShape[]{BASE_2, PILLAR, SIDE_PILLAR_1, SIDE_PILLAR_2, SIDE_PILLAR_3, SIDE_PILLAR_4});

    public DiffuserBlockEntity newBlockEntity(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return new DiffuserBlockEntity(pos, state);
    }

    @Override
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return DiffuserBlock.createECServerTicker(level, type, ECBlockEntityTypes.DIFFUSER, DiffuserBlockEntity::serverTick);
    }

    @Nonnull
    @Deprecated
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    @Deprecated
    public boolean m_7898_(@Nonnull BlockState state, @Nonnull LevelReader level, BlockPos pos) {
        return BlockEntityHelper.isValidContainer(state, level, pos.m_7495_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull RandomSource rand) {
        BlockEntityHelper.getBlockEntityAs((BlockGetter)level, pos, DiffuserBlockEntity.class).filter(DiffuserBlockEntity::hasDiffused).ifPresent(e -> ParticleHelper.createElementFlowParticle(e.getContainerElementType(), level, Vec3.m_82512_((Vec3i)pos), Direction.UP, 1.0f, rand));
    }
}

