/*
 * Decompiled with CFR 0.152.
 */
package sirttas.elementalcraft.block.anchor;

import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import sirttas.elementalcraft.block.anchor.TranslocationAnchorList;

public record TranslocationAnchorListMessage(List<BlockPos> list) {
    public static TranslocationAnchorListMessage create(Level level) {
        TranslocationAnchorList anchorList = TranslocationAnchorList.get(level);
        if (anchorList != null) {
            return new TranslocationAnchorListMessage(anchorList.getAnchors());
        }
        return new TranslocationAnchorListMessage(Collections.emptyList());
    }

    public static TranslocationAnchorListMessage decode(FriendlyByteBuf buf) {
        return new TranslocationAnchorListMessage(buf.m_236845_(b -> BlockPos.m_122022_((long)b.readLong())));
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236828_(this.list, (b, p) -> b.writeLong(p.m_121878_()));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (((NetworkEvent.Context)ctx.get()).getDirection().getReceptionSide() == LogicalSide.CLIENT) {
                TranslocationAnchorList.CLIENT_LIST.clear();
                TranslocationAnchorList.CLIENT_LIST.addAll(this.list);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

