/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.compat;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.fml.loading.FMLLoader;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.TorchmasterConfig;
import net.xalcon.torchmaster.common.logic.entityblocking.EntityBlockingEventHandler;

public class MCARebornCompat {
    public static void apply() {
        if (FMLLoader.getLoadingModList().getMods().stream().anyMatch(mod -> mod.getModId().equals("mca"))) {
            Torchmaster.Log.info("MCA Reborn detected, applying compat");
            MinecraftForge.EVENT_BUS.addListener(MCARebornCompat::onEntityJoinLevel);
        }
    }

    private static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        String type;
        if (event.getLevel() instanceof ServerLevel && !event.loadedFromDisk() && ((type = EntityType.m_20613_((EntityType)event.getEntity().m_6095_()).toString()).equals("mca:male_zombie_villager") || type.equals("mca:female_zombie_villager"))) {
            Boolean log = (Boolean)TorchmasterConfig.GENERAL.logSpawnChecks.get();
            if (!EntityBlockingEventHandler.shouldBlockEntity(event.getEntity(), event.getEntity().m_20097_())) {
                if (log.booleanValue()) {
                    Torchmaster.Log.debug("[MCA Compat] Allowing spawn of {}", (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()));
                }
                return;
            }
            if (log.booleanValue()) {
                Torchmaster.Log.debug("[MCA Compat] Blocking spawn of {}", (Object)EntityType.m_20613_((EntityType)event.getEntity().m_6095_()));
            }
            event.setCanceled(true);
        }
    }
}

