/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.world.level.structure.checks;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.data.DebugData;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public final class StructurePieceSampler {
    public static List<StructurePiece> getStructurePieces(StructureStart structureStart) {
        List<StructurePiece> structurePieces = structureStart.m_73602_();
        if (Structurify.getConfig().getDebugData().getSamplingMode() == DebugData.SamplingMode.MINIMAL) {
            return structurePieces;
        }
        structurePieces = StructurePieceSampler.getOnlyMainPieces(structurePieces);
        return structurePieces;
    }

    public static int[][] getStructurePieceSamples(List<StructurePiece> structurePieces, BlockPos structureCenter) {
        if (structurePieces.isEmpty()) {
            return new int[0][];
        }
        int[][] pieceSamples = StructurePieceSampler.getStructurePieceCorners(structurePieces);
        if (Structurify.getConfig().getDebugData().getSamplingMode() == DebugData.SamplingMode.MINIMAL) {
            return pieceSamples;
        }
        pieceSamples = StructurePieceSampler.mergeTouchingPositions(pieceSamples);
        if (Structurify.getConfig().getDebugData().getSamplingMode() == DebugData.SamplingMode.MERGED_SAMPLES) {
            return pieceSamples;
        }
        pieceSamples = StructurePieceSampler.orderStructureCornersByDistance(pieceSamples, structureCenter);
        return pieceSamples;
    }

    private static List<StructurePiece> getOnlyMainPieces(List<StructurePiece> pieces) {
        int count = pieces.size();
        ArrayList<StructurePiece> mainPieces = new ArrayList<StructurePiece>(count);
        for (int candidateIndex = 0; candidateIndex < count; ++candidateIndex) {
            StructurePiece candidatePiece = pieces.get(candidateIndex);
            BoundingBox candidateBox = candidatePiece.m_73547_();
            if (candidateBox.m_71056_() <= 2 || candidateBox.m_71058_() <= 2) continue;
            boolean isInsideAnotherPiece = false;
            for (int otherIndex = 0; otherIndex < count; ++otherIndex) {
                if (candidateIndex == otherIndex || !StructurePieceSampler.containsBox(pieces.get(otherIndex).m_73547_(), candidateBox)) continue;
                isInsideAnotherPiece = true;
                break;
            }
            if (isInsideAnotherPiece) continue;
            mainPieces.add(candidatePiece);
        }
        return mainPieces;
    }

    private static int[][] getStructurePieceCorners(List<StructurePiece> pieces) {
        int pieceCount = pieces.size();
        int[][] structureCorners = new int[pieceCount * 5][2];
        int structureCornerIndex = 0;
        for (StructurePiece piece : pieces) {
            BoundingBox pieceBox = piece.m_73547_();
            int minX = pieceBox.m_162395_();
            int minZ = pieceBox.m_162398_();
            int maxX = pieceBox.m_162399_();
            int maxZ = pieceBox.m_162401_();
            structureCorners[structureCornerIndex++] = new int[]{minX, minZ};
            structureCorners[structureCornerIndex++] = new int[]{minX, maxZ};
            structureCorners[structureCornerIndex++] = new int[]{maxX, minZ};
            structureCorners[structureCornerIndex++] = new int[]{maxX, maxZ};
            int centerX = (minX + maxX) / 2;
            int centerZ = (minZ + maxZ) / 2;
            structureCorners[structureCornerIndex++] = new int[]{centerX, centerZ};
        }
        return structureCorners;
    }

    private static int[][] mergeTouchingPositions(int[][] inputPositions) {
        HashSet<Long> uniqueKeys = new HashSet<Long>();
        ArrayList<int[]> uniquePositions = new ArrayList<int[]>();
        for (int[] position : inputPositions) {
            long key = ChunkPos.m_45589_((int)position[0], (int)position[1]);
            if (!uniqueKeys.add(key)) continue;
            uniquePositions.add(position);
        }
        ArrayList<int[]> mergedPositions = new ArrayList<int[]>();
        boolean[] visited = new boolean[uniquePositions.size()];
        for (int i = 0; i < uniquePositions.size(); ++i) {
            if (visited[i]) continue;
            ArrayList<int[]> group = new ArrayList<int[]>();
            ArrayDeque<Integer> queue = new ArrayDeque<Integer>();
            queue.add(i);
            visited[i] = true;
            while (!queue.isEmpty()) {
                int currentIndex = (Integer)queue.poll();
                int[] current = (int[])uniquePositions.get(currentIndex);
                group.add(current);
                for (int j = 0; j < uniquePositions.size(); ++j) {
                    int[] candidate;
                    if (visited[j] || Math.abs((candidate = (int[])uniquePositions.get(j))[0] - current[0]) > 1 || Math.abs(candidate[1] - current[1]) > 1) continue;
                    visited[j] = true;
                    queue.add(j);
                }
            }
            int[] best = (int[])group.get(0);
            double bestDistance = Double.MAX_VALUE;
            double avgX = group.stream().mapToInt(p -> p[0]).average().orElse(0.0);
            double avgZ = group.stream().mapToInt(p -> p[1]).average().orElse(0.0);
            for (int[] pos : group) {
                double dz;
                double dx = (double)pos[0] - avgX;
                double dist = dx * dx + (dz = (double)pos[1] - avgZ) * dz;
                if (!(dist < bestDistance) && (dist != bestDistance || pos[0] >= best[0] && (pos[0] != best[0] || pos[1] >= best[1]))) continue;
                best = pos;
                bestDistance = dist;
            }
            mergedPositions.add(best);
        }
        return (int[][])mergedPositions.toArray((T[])new int[mergedPositions.size()][]);
    }

    private static int[][] orderStructureCornersByDistance(int[][] samples, BlockPos structureCenter) {
        int centerX = structureCenter.m_123341_();
        int centerZ = structureCenter.m_123343_();
        ArrayList sortedSamples = new ArrayList(samples.length);
        sortedSamples.addAll(Arrays.asList(samples));
        sortedSamples.sort((a, b) -> {
            int ax = a[0];
            int az = a[1];
            int bx = b[0];
            int bz = b[1];
            int distA = Math.max(Math.abs(ax - centerX), Math.abs(az - centerZ));
            int distB = Math.max(Math.abs(bx - centerX), Math.abs(bz - centerZ));
            return Integer.compare(distB, distA);
        });
        int[][] result = new int[sortedSamples.size()][2];
        for (int i = 0; i < sortedSamples.size(); ++i) {
            result[i] = (int[])sortedSamples.get(i);
        }
        return result;
    }

    private static boolean containsBox(BoundingBox outer, BoundingBox inner) {
        return outer.m_162395_() <= inner.m_162395_() && outer.m_162399_() >= inner.m_162399_() && outer.m_162396_() <= inner.m_162396_() && outer.m_162400_() >= inner.m_162400_() && outer.m_162398_() <= inner.m_162398_() && outer.m_162401_() >= inner.m_162401_();
    }

    private StructurePieceSampler() {
    }
}

