/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.world.level.structure.checks;

import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.world.level.structure.checks.StructurePieceSampler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public final class StructureCheckData {
    private final ResourceLocation structureId;
    private final StructurifyStructure structure;
    private final StructureStart structureStart;
    private final BlockPos structureCenter;
    private List<StructurePiece> structurePieces = new ArrayList<StructurePiece>();
    private int[][] structurePieceSamples = null;

    public StructureCheckData(ResourceLocation structureId, StructurifyStructure structure, StructureStart structureStart) {
        this.structureId = structureId;
        this.structureStart = structureStart;
        this.structure = structure;
        this.structureCenter = structureStart.m_73601_().m_162394_();
    }

    public List<StructurePiece> getStructurePieces() {
        if (this.structurePieces.isEmpty()) {
            this.setStructureCheckData();
        }
        return this.structurePieces;
    }

    public int[][] getStructurePieceSamples() {
        if (this.structurePieceSamples == null) {
            this.setStructureCheckData();
        }
        return this.structurePieceSamples;
    }

    public ResourceLocation getStructureId() {
        return this.structureId;
    }

    public StructurifyStructure getStructure() {
        return this.structure;
    }

    public StructureStart getStructureStart() {
        return this.structureStart;
    }

    public BlockPos getStructureCenter() {
        return this.structureCenter;
    }

    private void setStructureCheckData() {
        this.structurePieces = StructurePieceSampler.getStructurePieces(this.structureStart);
        this.structurePieceSamples = StructurePieceSampler.getStructurePieceSamples(this.structurePieces, this.structureCenter);
    }
}

