/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.gui;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.config.StructurifyConfig;
import com.faboslav.structurify.common.config.client.api.controller.builder.StructureButtonControllerBuilder;
import com.faboslav.structurify.common.config.client.api.option.InvisibleOptionGroup;
import com.faboslav.structurify.common.config.client.api.option.OptionPair;
import com.faboslav.structurify.common.config.client.gui.structure.BiomeCheckOptions;
import com.faboslav.structurify.common.config.client.gui.structure.DistanceFromWorldCenterOptions;
import com.faboslav.structurify.common.config.client.gui.structure.FlatnessCheckOptions;
import com.faboslav.structurify.common.config.client.gui.structure.OverlapCheckOptions;
import com.faboslav.structurify.common.config.data.StructureData;
import com.faboslav.structurify.common.config.data.WorldgenDataProvider;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.common.util.LanguageUtil;
import com.faboslav.structurify.common.util.YACLUtil;
import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.LabelOption;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionAddable;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionGroup;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.BooleanControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public final class StructuresConfigScreen {
    private static final List<Option<Boolean>> structureOptions = new ArrayList<Option<Boolean>>();
    private static Option<OptionPair<Option<Integer>, Option<Integer>>> globalDistanceFromWorldCenterOption = null;
    private static Option<Boolean> enableGlobalFlatnessCheckOption = null;
    private static Option<Boolean> enableGlobalBiomeCheckOption = null;
    private static final List<Option<Boolean>> overrideDistanceFromWorldCenterOptions = new ArrayList<Option<Boolean>>();
    private static final List<Option<Boolean>> overrideFlatnessCheckOptions = new ArrayList<Option<Boolean>>();
    private static final List<Option<Boolean>> overrideBiomeCheckOptions = new ArrayList<Option<Boolean>>();
    private static final List<Option<Boolean>> enableFlatnessCheckOptions = new ArrayList<Option<Boolean>>();
    private static final List<Option<Boolean>> enableBiomeCheckOptions = new ArrayList<Option<Boolean>>();

    public static void createStructuresTab(YetAnotherConfigLib.Builder yacl, StructurifyConfig config) {
        ConfigCategory.Builder structureCategoryBuilder = ConfigCategory.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures_category.title")).tooltip(new Component[]{Component.m_237115_((String)"gui.structurify.structures_category.description")});
        StructuresConfigScreen.addGlobalSettings(structureCategoryBuilder, config);
        StructuresConfigScreen.addStructures(structureCategoryBuilder, config);
        globalDistanceFromWorldCenterOption.addListener((opt, enableGlobalFlatnessCheck) -> {
            for (Option<Boolean> overrideDistanceFromWorldCenterOption : overrideDistanceFromWorldCenterOptions) {
                overrideDistanceFromWorldCenterOption.setAvailable(!globalDistanceFromWorldCenterOption.isPendingValueDefault());
            }
        });
        enableGlobalFlatnessCheckOption.addListener((opt, enableGlobalFlatnessCheck) -> {
            for (int i = 0; i < overrideFlatnessCheckOptions.size(); ++i) {
                Option<Boolean> overrideFlatnessCheckOption = overrideFlatnessCheckOptions.get(i);
                overrideFlatnessCheckOption.setAvailable(enableGlobalFlatnessCheck.booleanValue());
                overrideFlatnessCheckOption.requestSetDefault();
                Option<Boolean> enableFlatnessCheckOption = enableFlatnessCheckOptions.get(i);
                enableFlatnessCheckOption.setAvailable(!overrideFlatnessCheckOption.available());
                enableFlatnessCheckOption.requestSetDefault();
            }
        });
        enableGlobalBiomeCheckOption.addListener((opt, enableGlobalBiomeCheck) -> {
            for (int i = 0; i < overrideBiomeCheckOptions.size(); ++i) {
                Option<Boolean> overrideBiomeCheckOption = overrideBiomeCheckOptions.get(i);
                overrideBiomeCheckOption.setAvailable(enableGlobalBiomeCheck.booleanValue());
                overrideBiomeCheckOption.requestSetDefault();
                Option<Boolean> enableBiomeCheckOption = enableBiomeCheckOptions.get(i);
                enableBiomeCheckOption.setAvailable(!overrideBiomeCheckOption.available());
                enableBiomeCheckOption.requestSetDefault();
            }
        });
        yacl.category(structureCategoryBuilder.build());
    }

    private static void addGlobalSettings(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
        OptionGroup.Builder globalStructuresGroupBuilder = OptionGroup.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.global.title").m_130938_(style -> style.m_131162_(Boolean.valueOf(true)))).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.global.description")}));
        globalStructuresGroupBuilder.option((Option)LabelOption.create((Component)Component.m_237115_((String)"gui.structurify.structures.structures.structure.title").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)))));
        Option disableAllStructuresOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.disable_all_structures.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.disable_all_structures.description")})).binding((Object)false, () -> config.disableAllStructures, disableAllStructures -> {
            config.disableAllStructures = disableAllStructures;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).formatValue(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes").m_130938_(style -> style.m_131140_(ChatFormatting.RED)) : Component.m_237115_((String)"gui.structurify.label.no").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)))).build();
        disableAllStructuresOption.addListener((opt, disableAllStructures) -> {
            for (Option<Boolean> structureOption : structureOptions) {
                structureOption.requestSet((Object)(disableAllStructures == false ? 1 : 0));
            }
        });
        globalStructuresGroupBuilder.option(disableAllStructuresOption);
        Option preventStructureOverlapOption = Option.createBuilder().name((Component)Component.m_237115_((String)"gui.structurify.structures.prevent_structure_overlap.title")).description(OptionDescription.of((Component[])new Component[]{Component.m_237115_((String)"gui.structurify.structures.prevent_structure_overlap.description")})).binding((Object)false, () -> config.preventStructureOverlap, preventStructureOverlap -> {
            config.preventStructureOverlap = preventStructureOverlap;
        }).controller(opt -> BooleanControllerBuilder.create((Option)opt).formatValue(val -> val != false ? Component.m_237115_((String)"gui.structurify.label.yes").m_130938_(style -> style.m_131140_(ChatFormatting.GREEN)) : Component.m_237115_((String)"gui.structurify.label.no").m_130938_(style -> style.m_131140_(ChatFormatting.RED)))).build();
        globalStructuresGroupBuilder.option(preventStructureOverlapOption);
        Map<String, Option<?>> globalDistanceFromWorldCenterOptions = DistanceFromWorldCenterOptions.addDistanceFromWorldCenterOptions((OptionAddable)globalStructuresGroupBuilder, config, "global");
        globalDistanceFromWorldCenterOption = globalDistanceFromWorldCenterOptions.get(DistanceFromWorldCenterOptions.DISTANCE_FROM_WORLD_CENTER_OPTION_NAME);
        Map<String, Option<?>> globalFlatnessCheckOptions = FlatnessCheckOptions.addFlatnessCheckOptions((OptionAddable)globalStructuresGroupBuilder, config, "global");
        enableGlobalFlatnessCheckOption = globalFlatnessCheckOptions.get(FlatnessCheckOptions.FLATNESS_CHECK_IS_ENABLED_OPTION_NAME);
        Map<String, Option<?>> globalBiomeCheckOptions = BiomeCheckOptions.addBiomeCheckOptions(globalStructuresGroupBuilder, config, "global");
        OptionGroup blackListedBiomesOption = (OptionGroup)globalBiomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_BLACKLISTED_BIOMES_OPTION_NAME);
        enableGlobalBiomeCheckOption = globalBiomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_IS_ENABLED_OPTION_NAME);
        structureCategoryBuilder.group(globalStructuresGroupBuilder.build());
        structureCategoryBuilder.group(blackListedBiomesOption);
    }

    private static void addStructures(ConfigCategory.Builder structureCategoryBuilder, StructurifyConfig config) {
        Map<String, StructureData> structures = WorldgenDataProvider.getStructures();
        HashMap structureGroups = new HashMap();
        for (Map.Entry<String, StructureData> entry : structures.entrySet()) {
            String string = entry.getKey();
            ResourceLocation structureId = Structurify.makeNamespacedId(string);
            String structureNamespace = structureId.m_135827_();
            StructureData structureData = entry.getValue();
            if (!structureGroups.containsKey(structureNamespace)) {
                structureGroups.put(structureNamespace, new HashMap());
            }
            ((HashMap)structureGroups.get(structureNamespace)).put(structureId, structureData);
        }
        HolderLookup.RegistryLookup<Biome> biomeRegistry = StructurifyRegistryManagerProvider.getBiomeRegistry();
        for (Map.Entry entry : structureGroups.entrySet()) {
            String structureNamespace = (String)entry.getKey();
            HashMap namespaceStructures = (HashMap)entry.getValue();
            OptionGroup.Builder invisibleGroup = new InvisibleOptionGroup.Builder().name((Component)Component.m_237113_((String)""));
            invisibleGroup.option((Option)YACLUtil.createEmptyLabelOption());
            structureCategoryBuilder.group(invisibleGroup.build());
            OptionGroup.Builder namespaceGroupBuilder = OptionGroup.createBuilder().name((Component)Component.m_237110_((String)"gui.structurify.structures.structures_group.title", (Object[])new Object[]{LanguageUtil.translateId(null, structureNamespace).getString()}).m_130938_(style -> style.m_131162_(Boolean.valueOf(true)))).description(OptionDescription.of((Component[])new Component[]{Component.m_237110_((String)"gui.structurify.structures.structures_group.description", (Object[])new Object[]{structureNamespace})}));
            namespaceGroupBuilder.option((Option)LabelOption.create((Component)Component.m_237115_((String)"gui.structurify.structures.structures.structure.title").m_130938_(style -> style.m_131136_(Boolean.valueOf(true)))));
            for (Map.Entry namespaceStructure : namespaceStructures.entrySet()) {
                StructureData structureData = (StructureData)namespaceStructure.getValue();
                String structureStringId = ((ResourceLocation)namespaceStructure.getKey()).toString();
                Option<Boolean> structureOption = StructuresConfigScreen.addStructure(structureData, structureStringId, biomeRegistry);
                namespaceGroupBuilder.option(structureOption);
                structureOptions.add(structureOption);
            }
            Map<String, Option<?>> namespaceDistanceFromWorldCenterOptions = DistanceFromWorldCenterOptions.addDistanceFromWorldCenterOptions((OptionAddable)namespaceGroupBuilder, config, structureNamespace);
            overrideDistanceFromWorldCenterOptions.add(namespaceDistanceFromWorldCenterOptions.get(DistanceFromWorldCenterOptions.OVERRIDE_GLOBAL_DISTANCE_FROM_WORLD_CENTER_OPTION_NAME));
            OverlapCheckOptions.addOverlapCheckOptions((OptionAddable)namespaceGroupBuilder, config, structureNamespace);
            Map<String, Option<?>> namespaceFlatnessCheckOptions = FlatnessCheckOptions.addFlatnessCheckOptions((OptionAddable)namespaceGroupBuilder, config, structureNamespace);
            overrideFlatnessCheckOptions.add(namespaceFlatnessCheckOptions.get(FlatnessCheckOptions.OVERRIDE_GLOBAL_FLATNESS_CHECK_OPTION_NAME));
            enableFlatnessCheckOptions.add(namespaceFlatnessCheckOptions.get(FlatnessCheckOptions.FLATNESS_CHECK_IS_ENABLED_OPTION_NAME));
            Map<String, Option<?>> namespaceBiomeCheckOptions = BiomeCheckOptions.addBiomeCheckOptions(namespaceGroupBuilder, config, structureNamespace);
            OptionGroup blackListedBiomesOption = (OptionGroup)namespaceBiomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_BLACKLISTED_BIOMES_OPTION_NAME);
            structureCategoryBuilder.group(namespaceGroupBuilder.build());
            structureCategoryBuilder.group(blackListedBiomesOption);
            overrideBiomeCheckOptions.add(namespaceBiomeCheckOptions.get(BiomeCheckOptions.OVERRIDE_GLOBAL_BIOME_CHECK_OPTION_NAME));
            enableBiomeCheckOptions.add(namespaceBiomeCheckOptions.get(BiomeCheckOptions.BIOME_CHECK_IS_ENABLED_OPTION_NAME));
        }
        OptionGroup.Builder builder = new InvisibleOptionGroup.Builder().name((Component)Component.m_237113_((String)""));
        builder.option((Option)YACLUtil.createEmptyLabelOption());
        structureCategoryBuilder.group(builder.build());
    }

    private static Option<Boolean> addStructure(StructureData structureData, String structureId, HolderLookup.RegistryLookup<Biome> biomeRegistry) {
        Option.Builder structureOptionBuilder = Option.createBuilder().name((Component)LanguageUtil.translateId("structure", structureId)).binding((Object)true, () -> !structureData.isDisabled(), isEnabled -> structureData.setDisabled(isEnabled == false)).controller(opt -> StructureButtonControllerBuilder.create((Option<Boolean>)opt, structureId).formatValue((ValueFormatter<Boolean>)((ValueFormatter)val -> val != false ? Component.m_237115_((String)"gui.structurify.label.enabled") : Component.m_237115_((String)"gui.structurify.label.disabled"))).coloured(true));
        structureOptionBuilder.description(v -> {
            OptionDescription.Builder descriptionBuilder = OptionDescription.createBuilder();
            descriptionBuilder.text(new Component[]{Component.m_237115_((String)"gui.structurify.structures.biomes_description").m_7220_((Component)Component.m_237113_((String)"\n"))});
            for (String biome : structureData.getBiomes()) {
                if (biome.contains("#")) {
                    TagKey biomeTagKey;
                    HolderSet.Named biomeTagHolder;
                    if (biomeRegistry == null || (biomeTagHolder = (HolderSet.Named)biomeRegistry.m_254901_(biomeTagKey = TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)Structurify.makeNamespacedId(biome.replace("#", "")))).orElse(null)) == null) continue;
                    for (Holder biomeHolder : biomeTagHolder.m_203614_().toList()) {
                        descriptionBuilder.text(new Component[]{Component.m_237113_((String)" - ").m_7220_((Component)LanguageUtil.translateId("biome", ((ResourceKey)biomeHolder.m_203439_().left().get()).m_135782_().m_214298_()))});
                    }
                    continue;
                }
                descriptionBuilder.text(new Component[]{Component.m_237113_((String)" - ").m_7220_((Component)LanguageUtil.translateId("biome", biome))});
            }
            descriptionBuilder.text(new Component[]{Component.m_237113_((String)"\n\n").m_7220_((Component)Component.m_237115_((String)"gui.structurify.structures.warning")).m_130938_(style -> style.m_131140_(ChatFormatting.YELLOW))});
            return descriptionBuilder.build();
        });
        return structureOptionBuilder.build();
    }
}

