/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.option;

import com.faboslav.structurify.common.config.client.api.controller.DualController;
import com.faboslav.structurify.common.config.client.api.option.OptionPair;
import com.google.common.collect.ImmutableSet;
import dev.isxander.yacl3.api.Binding;
import dev.isxander.yacl3.api.Controller;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.OptionEventListener;
import dev.isxander.yacl3.api.OptionFlag;
import dev.isxander.yacl3.api.StateManager;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.impl.OptionImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class HolderOption<K extends Option<?>, V extends Option<?>>
extends OptionImpl<OptionPair<K, V>> {
    private final OptionPair<K, V> optionPair;
    private final K firstOption;
    private final V secondOption;

    private HolderOption(@NotNull Component name, @NotNull Function<OptionPair<K, V>, OptionDescription> descriptionFunction, @NotNull Function<Option<OptionPair<K, V>>, DualController<K, V>> controlGetter, @NotNull StateManager<OptionPair<K, V>> stateManager, boolean available, @NotNull ImmutableSet<OptionFlag> flags, @NotNull Collection<OptionEventListener<OptionPair<K, V>>> listeners) {
        super(name, descriptionFunction, opt -> (Controller)controlGetter.apply((Option)opt), stateManager, available, flags, listeners);
        this.optionPair = (OptionPair)stateManager.get();
        this.firstOption = (Option)this.optionPair.firstOption();
        this.secondOption = (Option)this.optionPair.secondOption();
    }

    public boolean available() {
        return this.firstOption.available() && this.secondOption.available();
    }

    public void setAvailable(boolean available) {
        boolean firstChanged = this.firstOption.available() != available;
        boolean secondChanged = this.secondOption.available() != available;
        this.firstOption.setAvailable(available);
        this.secondOption.setAvailable(available);
        if (firstChanged || secondChanged) {
            if (!available) {
                this.firstOption.stateManager().sync();
                this.secondOption.stateManager().sync();
            }
            super.setAvailable(available);
        }
    }

    public static <K extends Option<?>, V extends Option<?>> HolderOptionBuilder<K, V> createBuilder() {
        return new HolderOptionBuilder();
    }

    public static <K extends Option<?>, V extends Option<?>> HolderOptionBuilder<K, V> createBuilder(OptionPair<K, V> optionPair) {
        return new HolderOptionBuilder<K, V>().optionPair(optionPair);
    }

    @ApiStatus.Internal
    public static final class HolderOptionBuilder<K extends Option<?>, V extends Option<?>>
    implements Option.Builder<OptionPair<K, V>> {
        private Component name = Component.m_237113_((String)"Name not specified!").m_130940_(ChatFormatting.RED);
        private Function<OptionPair<K, V>, OptionDescription> descriptionFunction = pending -> OptionDescription.EMPTY;
        private Function<Option<OptionPair<K, V>>, DualController<K, V>> controlGetter;
        private OptionPair<K, V> optionPair;
        private boolean available = true;
        private final Set<OptionFlag> flags = new HashSet<OptionFlag>();
        private final List<OptionEventListener<OptionPair<K, V>>> listeners = new ArrayList<OptionEventListener<OptionPair<K, V>>>();

        public Option.Builder<OptionPair<K, V>> name(@NotNull Component name) {
            Validate.notNull((Object)name, (String)"`name` cannot be null", (Object[])new Object[0]);
            this.name = name;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> description(@NotNull OptionDescription description) {
            Validate.notNull((Object)description, (String)"`description` cannot be null", (Object[])new Object[0]);
            return this.description((OptionPair<K, V> pending) -> description);
        }

        public Option.Builder<OptionPair<K, V>> description(@NotNull Function<OptionPair<K, V>, OptionDescription> descriptionFunction) {
            Validate.notNull(descriptionFunction, (String)"`descriptionFunction` cannot be null", (Object[])new Object[0]);
            this.descriptionFunction = descriptionFunction;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> controller(@NotNull Function<Option<OptionPair<K, V>>, ControllerBuilder<OptionPair<K, V>>> controllerBuilder) {
            Validate.notNull(controllerBuilder, (String)"`controllerBuilder` cannot be null", (Object[])new Object[0]);
            return this.customController(opt -> ((ControllerBuilder)controllerBuilder.apply((Option)opt)).build());
        }

        public Option.Builder<OptionPair<K, V>> customController(@NotNull Function<Option<OptionPair<K, V>>, Controller<OptionPair<K, V>>> control) {
            Validate.notNull(control, (String)"`control` cannot be null", (Object[])new Object[0]);
            this.controlGetter = opt -> (DualController)control.apply((Option)opt);
            return this;
        }

        public Option.Builder<OptionPair<K, V>> stateManager(@NotNull StateManager<OptionPair<K, V>> stateManager) {
            throw new UnsupportedOperationException("HolderOption uses its own state manager. Use the child options' state managers instead.");
        }

        public Option.Builder<OptionPair<K, V>> binding(@NotNull Binding<OptionPair<K, V>> binding) {
            throw new UnsupportedOperationException("HolderOption does not support binding(). Bind the child options instead.");
        }

        public Option.Builder<OptionPair<K, V>> binding(@NotNull OptionPair<K, V> def, @NotNull @NotNull Supplier<@NotNull OptionPair<K, V>> getter, @NotNull @NotNull Consumer<@NotNull OptionPair<K, V>> setter) {
            throw new UnsupportedOperationException("HolderOption does not support binding(). Bind the child options instead.");
        }

        public HolderOptionBuilder<K, V> optionPair(@NotNull OptionPair<K, V> optionPair) {
            Validate.notNull(optionPair, (String)"`optionPair` cannot be null", (Object[])new Object[0]);
            this.optionPair = optionPair;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> available(boolean available) {
            this.available = available;
            return this;
        }

        public Option.Builder<OptionPair<K, V>> flag(OptionFlag ... flag) {
            Validate.notNull((Object)flag, (String)"`flag` must not be null", (Object[])new Object[0]);
            this.flags.addAll(Arrays.asList(flag));
            return this;
        }

        public Option.Builder<OptionPair<K, V>> flags(@NotNull Collection<? extends OptionFlag> flags) {
            Validate.notNull(flags, (String)"`flags` must not be null", (Object[])new Object[0]);
            this.flags.addAll(flags);
            return this;
        }

        public Option.Builder<OptionPair<K, V>> addListener(@NotNull OptionEventListener<OptionPair<K, V>> optionEventListener) {
            Validate.notNull(optionEventListener, (String)"`optionEventListener` must not be null", (Object[])new Object[0]);
            this.listeners.add(optionEventListener);
            return this;
        }

        public Option.Builder<OptionPair<K, V>> addListeners(@NotNull Collection<OptionEventListener<OptionPair<K, V>>> collection) {
            Validate.notNull(collection, (String)"`collection` must not be null", (Object[])new Object[0]);
            this.listeners.addAll(collection);
            return this;
        }

        @Deprecated
        public Option.Builder<OptionPair<K, V>> instant(boolean instant) {
            throw new UnsupportedOperationException("HolderOption does not support instant(). Use the child options' state managers instead.");
        }

        @Deprecated
        public Option.Builder<OptionPair<K, V>> listener(@NotNull BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>> listener) {
            Validate.notNull(listener, (String)"`listener` must not be null", (Object[])new Object[0]);
            return this.addListener((opt, event) -> listener.accept(opt, (OptionPair)opt.pendingValue()));
        }

        @Deprecated
        public Option.Builder<OptionPair<K, V>> listeners(@NotNull Collection<BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>>> listeners) {
            Validate.notNull(listeners, (String)"`listeners` must not be null", (Object[])new Object[0]);
            for (BiConsumer<Option<OptionPair<K, V>>, OptionPair<K, V>> listener : listeners) {
                this.listener(listener);
            }
            return this;
        }

        public Option<OptionPair<K, V>> build() {
            Validate.notNull(this.optionPair, (String)"`optionPair` must not be null when building HolderOption", (Object[])new Object[0]);
            Validate.notNull(this.controlGetter, (String)"`control` must not be null when building HolderOption", (Object[])new Object[0]);
            Option firstOption = (Option)this.optionPair.firstOption();
            Option secondOption = (Option)this.optionPair.secondOption();
            MutableComponent combinedName = firstOption.name().m_6881_().m_130946_(" & ").m_7220_((Component)secondOption.name().m_6881_());
            Function combinedDescriptionFunction = pending -> OptionDescription.of((Component[])new Component[]{firstOption.description().text().m_6881_().m_130946_("\n\n").m_7220_(secondOption.description().text())});
            PairStateManager<K, V> stateManager = new PairStateManager<K, V>(this.optionPair);
            return new HolderOption((Component)combinedName, combinedDescriptionFunction, this.controlGetter, stateManager, this.available, (ImmutableSet<OptionFlag>)ImmutableSet.copyOf(this.flags), this.listeners);
        }
    }

    private static final class PairStateManager<K extends Option<?>, V extends Option<?>>
    implements StateManager<OptionPair<K, V>> {
        private final OptionPair<K, V> optionPair;
        private final K firstOption;
        private final V secondOption;
        private final List<StateManager.StateListener<OptionPair<K, V>>> listeners = new ArrayList<StateManager.StateListener<OptionPair<K, V>>>();

        private PairStateManager(@NotNull OptionPair<K, V> optionPair) {
            this.optionPair = optionPair;
            this.firstOption = (Option)optionPair.firstOption();
            this.secondOption = (Option)optionPair.secondOption();
            this.firstOption.stateManager().addListener((oldValue, newValue) -> this.fire());
            this.secondOption.stateManager().addListener((oldValue, newValue) -> this.fire());
        }

        public void set(OptionPair<K, V> value) {
            Validate.notNull(value, (String)"`value` cannot be null", (Object[])new Object[0]);
            boolean isSamePair = value.firstOption() == this.firstOption && value.secondOption() == this.secondOption;
            Validate.isTrue((boolean)isSamePair, (String)"HolderOption does not support replacing its option pair", (Object[])new Object[0]);
            this.fire();
        }

        public OptionPair<K, V> get() {
            return this.optionPair;
        }

        public void apply() {
            this.firstOption.applyValue();
            this.secondOption.applyValue();
        }

        public void resetToDefault(StateManager.ResetAction action) {
            this.firstOption.stateManager().resetToDefault(action);
            this.secondOption.stateManager().resetToDefault(action);
        }

        public void sync() {
            this.firstOption.stateManager().sync();
            this.secondOption.stateManager().sync();
        }

        public boolean isSynced() {
            return this.firstOption.stateManager().isSynced() && this.secondOption.stateManager().isSynced();
        }

        public boolean isAlwaysSynced() {
            return this.firstOption.stateManager().isAlwaysSynced() && this.secondOption.stateManager().isAlwaysSynced();
        }

        public boolean isDefault() {
            return this.firstOption.stateManager().isDefault() && this.secondOption.stateManager().isDefault();
        }

        public void addListener(StateManager.StateListener<OptionPair<K, V>> stateListener) {
            Validate.notNull(stateListener, (String)"`stateListener` cannot be null", (Object[])new Object[0]);
            this.listeners.add(stateListener);
        }

        private void fire() {
            for (StateManager.StateListener<OptionPair<K, V>> listener : this.listeners) {
                listener.onStateChange(this.optionPair, this.optionPair);
            }
        }
    }
}

