/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.config.client.api.controller;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.StructurifyClient;
import com.faboslav.structurify.common.config.client.gui.StructureConfigScreen;
import com.faboslav.structurify.common.config.client.gui.StructurifyConfigScreen;
import com.faboslav.structurify.common.util.LanguageUtil;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.TextScaledButtonWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.BooleanController;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class StructureButtonController
extends BooleanController {
    private final String structureId;

    public StructureButtonController(Option<Boolean> option, String structureId, Function<Boolean, Component> valueFormatter, boolean coloured) {
        super(option, valueFormatter, coloured);
        this.structureId = structureId;
    }

    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new BooleanWithConfigButtonWidget(this, screen, widgetDimension, this.structureId);
    }

    public static final class BooleanWithConfigButtonWidget
    extends AbstractWidget {
        private static final int CONFIG_BUTTON_WIDTH = 20;
        private static final int CONFIG_BUTTON_HEIGHT = 20;
        private final YACLScreen screen;
        private final String structureId;
        private final BooleanController.BooleanControllerElement booleanElement;
        private final TextScaledButtonWidget configurationButton;
        private boolean focused;

        public BooleanWithConfigButtonWidget(BooleanController controller, YACLScreen screen, Dimension<Integer> dim, String structureId) {
            super(dim);
            this.screen = screen;
            this.structureId = structureId;
            this.booleanElement = new BooleanController.BooleanControllerElement(controller, screen, dim);
            this.configurationButton = new TextScaledButtonWidget((Screen)screen, 0, 0, 20, 20, 1.0f, (Component)Component.m_237113_((String)"\u2699").m_130938_(style -> style.m_131136_(Boolean.valueOf(true))), button -> this.openStructureConfig());
            this.configurationButton.m_257544_(Tooltip.m_257550_((Component)Component.m_237110_((String)"gui.structurify.structures.structure.detail_button.tooltip", (Object[])new Object[]{LanguageUtil.translateId("structure", structureId)})));
            this.setDimension(dim);
        }

        private void openStructureConfig() {
            StructurifyConfigScreen configScreen = StructurifyClient.getConfigScreen();
            if (configScreen == null) {
                return;
            }
            this.screen.finishOrSave();
            YACLScreen structureScreen = StructureConfigScreen.create(Structurify.getConfig(), this.structureId, (Screen)this.screen);
            configScreen.saveScreenState(this.screen);
            this.client.m_91152_((Screen)structureScreen);
            configScreen.loadScreenState(structureScreen);
        }

        public void setDimension(Dimension<Integer> dim) {
            super.setDimension(dim);
            int booleanWidth = Math.max(0, (Integer)dim.width() - 20);
            Dimension booleanDim = dim.withWidth((Number)booleanWidth);
            this.booleanElement.setDimension(booleanDim);
            int gearX = (Integer)dim.xLimit() - 20;
            int gearY = (Integer)dim.y();
            this.configurationButton.m_252865_(gearX);
            this.configurationButton.m_253211_(gearY);
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float tickDelta) {
            this.booleanElement.m_88315_(graphics, mouseX, mouseY, tickDelta);
            this.configurationButton.f_93623_ = this.booleanElement.m_142518_();
            this.configurationButton.m_253211_(((Integer)this.getDimension().y()).intValue());
            this.configurationButton.m_88315_(graphics, mouseX, mouseY, tickDelta);
        }

        public boolean canReset() {
            return true;
        }

        public void m_94757_(double mouseX, double mouseY) {
            this.configurationButton.m_94757_(mouseX, mouseY);
            this.booleanElement.m_94757_(mouseX, mouseY);
        }

        public void unfocus() {
            this.focused = false;
            this.booleanElement.unfocus();
            this.configurationButton.m_93692_(false);
            super.unfocus();
        }

        public void m_93692_(boolean focused) {
            this.focused = focused;
            if (!focused) {
                this.booleanElement.m_93692_(false);
                this.configurationButton.m_93692_(false);
                return;
            }
            this.booleanElement.m_93692_(true);
            this.configurationButton.m_93692_(false);
        }

        public boolean m_93696_() {
            return this.focused || this.booleanElement.m_93696_() || this.configurationButton.m_93696_();
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            if (this.configurationButton.m_5953_(mouseX, mouseY)) {
                return true;
            }
            return this.booleanElement.m_5953_(mouseX, mouseY);
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            this.configurationButton.f_93623_ = this.booleanElement.m_142518_();
            boolean overConfig = this.configurationButton.m_5953_(mouseX, mouseY);
            if (overConfig) {
                this.booleanElement.m_93692_(false);
                this.configurationButton.m_93692_(true);
                this.focused = true;
                if (this.configurationButton.m_6375_(mouseX, mouseY, button)) {
                    return true;
                }
            }
            this.configurationButton.m_93692_(false);
            this.booleanElement.m_93692_(true);
            this.focused = true;
            return this.booleanElement.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            if (this.configurationButton.m_6348_(mouseX, mouseY, button)) {
                return true;
            }
            return this.booleanElement.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.configurationButton.m_7979_(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            return this.booleanElement.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (this.configurationButton.m_93696_() && this.configurationButton.m_7933_(keyCode, scanCode, modifiers)) {
                return true;
            }
            return this.booleanElement.m_7933_(keyCode, scanCode, modifiers);
        }

        public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
            if (this.configurationButton.m_93696_() && this.configurationButton.m_7920_(keyCode, scanCode, modifiers)) {
                return true;
            }
            return this.booleanElement.m_7920_(keyCode, scanCode, modifiers);
        }

        public boolean m_5534_(char chr, int modifiers) {
            if (this.configurationButton.m_93696_() && this.configurationButton.m_5534_(chr, modifiers)) {
                return true;
            }
            return this.booleanElement.m_5534_(chr, modifiers);
        }
    }
}

