/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.recipeviewers.rei;

import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.client.registry.transfer.simple.SimpleTransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.transfer.info.stack.VanillaSlotAccessor;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import tfar.craftingstation.CraftingStationMenu;

public class ReiTransferHandler
implements SimpleTransferHandler {
    private final Class<CraftingStationMenu> containerClass;
    private final CategoryIdentifier<DefaultCraftingDisplay<?>> categoryIdentifier;

    public ReiTransferHandler(Class<CraftingStationMenu> containerClass, CategoryIdentifier<DefaultCraftingDisplay<?>> categoryIdentifier) {
        this.containerClass = containerClass;
        this.categoryIdentifier = categoryIdentifier;
    }

    public TransferHandler.ApplicabilityResult checkApplicable(TransferHandler.Context context) {
        if (!this.containerClass.isInstance(context.getMenu()) || !this.categoryIdentifier.equals((Object)context.getDisplay().getCategoryIdentifier()) || context.getContainerScreen() == null) {
            return TransferHandler.ApplicabilityResult.createNotApplicable();
        }
        return TransferHandler.ApplicabilityResult.createApplicable();
    }

    public Iterable<SlotAccessor> getInputSlots(TransferHandler.Context context) {
        return IntStream.range(1, 10).mapToObj(id -> SlotAccessor.fromSlot((Slot)context.getMenu().m_38853_(id))).toList();
    }

    public Iterable<SlotAccessor> getInventorySlots(TransferHandler.Context context) {
        LocalPlayer player = context.getMinecraft().f_91074_;
        int sideContainerOffset = 10 + ((CraftingStationMenu)context.getMenu()).subContainerSize;
        return IntStream.range(10, context.getMenu().f_38839_.size()).mapToObj(index -> {
            if (index < sideContainerOffset) {
                return new VanillaSlotAccessor(context.getMenu().m_38853_(index));
            }
            return SlotAccessor.fromPlayerInventory((Player)player, (int)(index - sideContainerOffset));
        }).collect(Collectors.toList());
    }
}

