/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import tfar.craftingstation.CraftingStationMenu;
import tfar.craftingstation.client.ClearButton;
import tfar.craftingstation.client.InfoFakeButton;
import tfar.craftingstation.client.PriorityButton;
import tfar.craftingstation.client.TabButton;
import tfar.craftingstation.network.C2SClearPacket;
import tfar.craftingstation.network.C2SPriorityPacket;
import tfar.craftingstation.network.PacketHandler;

public class CraftingStationScreen
extends AbstractContainerScreen<CraftingStationMenu> {
    public static final ResourceLocation CRAFTING_TABLE_GUI_TEXTURES = new ResourceLocation("textures/gui/container/crafting_table.png");
    public static final ResourceLocation SCROLLBAR_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static final ResourceLocation SCROLLBAR_BACKGROUND_AND_TAB = new ResourceLocation("textures/gui/container/creative_inventory/tab_items.png");
    public static final ResourceLocation SECONDARY_GUI_TEXTURE = new ResourceLocation("craftingstation", "textures/gui/secondary.png");
    private double currentScroll;
    private boolean isScrolling = false;
    private int topRow = 0;
    private boolean[] jeiWarningPages;
    private InfoFakeButton info;

    public CraftingStationScreen(CraftingStationMenu p_i51094_1_, Inventory p_i51094_2_, Component p_i51094_3_) {
        super((AbstractContainerMenu)p_i51094_1_, p_i51094_2_, p_i51094_3_);
    }

    protected void m_7856_() {
        super.m_7856_();
        if (((CraftingStationMenu)this.f_97732_).hasSideContainers) {
            this.jeiWarningPages = new boolean[((CraftingStationMenu)this.f_97732_).containerStarts.size()];
            for (int i = 0; i < ((CraftingStationMenu)this.f_97732_).containerStarts.size(); ++i) {
                this.m_142416_((GuiEventListener)new TabButton(this.f_97735_ - 128 + 21 * i, this.f_97736_ - 22, 22, 28, button -> this.changeContainer(((TabButton)button).index), i, ((CraftingStationMenu)this.f_97732_).blocks.get(i), this));
                this.jeiWarningPages[i] = false;
                Container container = ((CraftingStationMenu)this.f_97732_).getContainerFromId(i);
                if (container == null) continue;
                for (int j = 0; j < container.m_6643_(); ++j) {
                    boolean modifiable;
                    ItemStack item = container.m_8020_(j);
                    boolean bl = modifiable = container.m_7013_(j, item) && container.m_271862_(container, j, item);
                    if (item.m_41619_() || modifiable) continue;
                    this.jeiWarningPages[i] = true;
                }
            }
            this.info = new InfoFakeButton(this.f_97735_ - 14, this.f_97736_ + 3, 12, 12, (Component)Component.m_237113_((String)"?"));
            this.info.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"text.crafting_station.jei_nopull_output")));
            this.m_142416_((GuiEventListener)this.info);
            this.info.f_93624_ = this.jeiWarningPages[0];
        }
        PriorityButton priority = new PriorityButton(this.f_97735_ + 85, this.f_97736_ + 16, 17, 17, (CraftingStationMenu)this.f_97732_, b -> PacketHandler.INSTANCE.sendToServer((Object)new C2SPriorityPacket()));
        this.m_142416_((GuiEventListener)priority);
        ClearButton clear = new ClearButton(priority.m_252754_() + 19, this.f_97736_ + 16, 13, 13, b -> PacketHandler.INSTANCE.sendToServer((Object)new C2SClearPacket(CraftingStationScreen.m_96638_())));
        clear.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)"text.crafting_station.clear")));
        this.m_142416_((GuiEventListener)clear);
    }

    protected boolean m_7467_(double mouseX, double mouseY, int guiLeftIn, int guiTopIn, int mouseButton) {
        boolean b = super.m_7467_(mouseX, mouseY, guiLeftIn, guiTopIn, mouseButton) && (!((CraftingStationMenu)this.f_97732_).hasSideContainers || !this.m_6774_(-126, -16, 126, 32 + this.f_97727_, mouseX, mouseY));
        return b;
    }

    public void changeContainer(int container) {
        this.info.f_93624_ = this.jeiWarningPages[container];
        ((CraftingStationMenu)this.f_97732_).changeContainer(container);
    }

    public void m_88315_(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(stack);
        super.m_88315_(stack, mouseX, mouseY, partialTicks);
        this.m_280072_(stack, mouseX, mouseY);
    }

    protected void m_280003_(GuiGraphics stack, int p_146979_1_, int p_146979_2_) {
        super.m_280003_(stack, p_146979_1_, p_146979_2_);
        if (((CraftingStationMenu)this.f_97732_).hasSideContainers) {
            stack.m_280056_(this.f_96547_, this.getTruncatedString(), -122, 6, 0x404040, false);
        }
    }

    String getTruncatedString() {
        String string = ((CraftingStationMenu)this.f_97732_).containerNames.get(((CraftingStationMenu)this.f_97732_).getCurrentContainer()).getString();
        if (string.length() > 23) {
            return string.substring(0, 23) + "...";
        }
        return string;
    }

    protected void m_7286_(GuiGraphics stack, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        stack.m_280218_(CRAFTING_TABLE_GUI_TEXTURES, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        int i = this.f_97735_;
        int i1 = i - 16;
        int i2 = i1 + 14;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        if (((CraftingStationMenu)this.f_97732_).hasSideContainers) {
            stack.m_280218_(SECONDARY_GUI_TEXTURE, i - 130, j, 0, 0, this.f_97726_, this.f_97727_ + 18);
            CraftingStationScreen.bind(SCROLLBAR_BACKGROUND_AND_TAB);
            int totalSlots = ((CraftingStationMenu)this.f_97732_).getActiveSubContainerSlotCount();
            int slotsToDraw = 54;
            if (totalSlots < slotsToDraw) {
                slotsToDraw = totalSlots;
            } else if (this.hasScrollbar() && this.topRow == ((CraftingStationMenu)this.f_97732_).getRows() - 9 && totalSlots % 6 != 0) {
                slotsToDraw = 48 + totalSlots % 6;
            }
            int offset = this.hasScrollbar() ? -126 : -118;
            for (int i3 = 0; i3 < slotsToDraw; ++i3) {
                int j1 = i3 % 6;
                int k1 = i3 / 6;
                stack.m_280218_(SCROLLBAR_BACKGROUND_AND_TAB, i + j1 * 18 + offset, 18 * k1 + j + 16, 8, 17, 18, 18);
            }
            if (this.hasScrollbar()) {
                stack.m_280218_(SCROLLBAR_BACKGROUND_AND_TAB, i - 17, j + 16, 174, 17, 14, 100);
                stack.m_280218_(SCROLLBAR_BACKGROUND_AND_TAB, i - 17, j + 67, 174, 18, 14, 111);
                CraftingStationScreen.bind(SCROLLBAR_AND_TAB);
                int k = (int)((double)(j + 17) + 145.0 * this.currentScroll);
                if (this.isScrolling && mouseX <= i2 && mouseX >= i1) {
                    stack.m_280218_(SCROLLBAR_AND_TAB, i - 16, k, 244, 0, 12, 15);
                } else {
                    stack.m_280218_(SCROLLBAR_AND_TAB, i - 16, k, 232, 0, 12, 15);
                }
            }
        }
    }

    private static void bind(ResourceLocation tex) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tex);
    }

    public boolean m_6375_(double mouseX, double mouseY, int scroll) {
        this.isScrolling = this.hasScrollbar();
        return super.m_6375_(mouseX, mouseY, scroll);
    }

    public boolean m_7979_(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.isScrolling) {
            int j = this.f_97736_;
            int j1 = j + 24;
            int j2 = j1 + 145;
            int k = this.f_97735_;
            int k1 = k - 16;
            int k2 = k1 + 14;
            if (mouseX <= (double)k2 && mouseX >= (double)k1) {
                this.currentScroll = (mouseY - (double)j1) / (double)((float)(j2 - j1) - 0.0f);
                this.currentScroll = Mth.m_14008_((double)this.currentScroll, (double)0.0, (double)1.0);
                this.scrollTo(this.currentScroll);
            }
        }
        return super.m_7979_(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean m_6348_(double mouseX, double mouseY, int scroll) {
        this.isScrolling = false;
        return super.m_6348_(mouseX, mouseY, scroll);
    }

    private boolean hasScrollbar() {
        return ((CraftingStationMenu)this.f_97732_).getRows() > 9;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollDelta) {
        if (this.hasScrollbar() && mouseX < (double)this.f_97735_ && mouseX > (double)(this.f_97735_ - 20)) {
            this.setTopRow((int)((double)this.topRow - scrollDelta), false);
            return true;
        }
        return false;
    }

    private void scrollTo(double scroll) {
        this.setTopRow((int)Math.round((double)(((CraftingStationMenu)this.f_97732_).getRows() - 9) * scroll), true);
    }

    private void setTopRow(int offset, boolean smooth) {
        this.topRow = offset;
        if (this.topRow < 0) {
            this.topRow = 0;
        } else if (this.topRow > ((CraftingStationMenu)this.f_97732_).getRows() - 9) {
            this.topRow = ((CraftingStationMenu)this.f_97732_).getRows() - 9;
        }
        ((CraftingStationMenu)this.f_97732_).updateSlotPositions(this.topRow);
        if (!smooth) {
            this.currentScroll = (double)this.topRow / (double)(((CraftingStationMenu)this.f_97732_).getRows() - 9);
        }
    }

    public boolean hasSideContainer() {
        return ((CraftingStationMenu)this.f_97732_).hasSideContainers;
    }
}

