/*
 * Decompiled with CFR 0.152.
 */
package tfar.craftingstation;

import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;
import tfar.craftingstation.CraftingStationBlockEntity;

public class CraftingStationBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final VoxelShape shape;
    public static final BooleanProperty WATERLOGGED;
    public static final DirectionProperty FACING;

    public CraftingStationBlock(BlockBehaviour.Properties p_i48440_1_) {
        super(p_i48440_1_);
        ((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState p_225533_1_, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult p_225533_6_) {
        BlockEntity tileEntity;
        if (!world.f_46443_ && (tileEntity = world.m_7702_(pos)) instanceof MenuProvider) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tileEntity), (BlockPos)tileEntity.m_58899_());
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider m_7246_(BlockState state, Level world, BlockPos pos) {
        BlockEntity te = world.m_7702_(pos);
        return te instanceof CraftingStationBlockEntity ? (MenuProvider)te : null;
    }

    public void m_6810_(BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tileentity = worldIn.m_7702_(pos);
            if (tileentity instanceof CraftingStationBlockEntity) {
                CraftingStationBlockEntity craftingStationBlock = (CraftingStationBlockEntity)tileentity;
                CraftingStationBlock.dropItems((IItemHandler)craftingStationBlock.input, worldIn, pos);
                worldIn.m_46717_(pos, (Block)this);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public static void dropItems(IItemHandler inv, Level world, BlockPos pos) {
        IntStream.range(0, inv.getSlots()).mapToObj(arg_0 -> ((IItemHandler)inv).getStackInSlot(arg_0)).filter(s -> !s.m_41619_()).forEach(stack -> Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    @Nonnull
    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_206840_1_) {
        p_206840_1_.m_61104_(new Property[]{WATERLOGGED, FACING});
    }

    @Nonnull
    public FluidState m_5888_(BlockState p_204507_1_) {
        return (Boolean)p_204507_1_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_204507_1_);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos;
        Level level = ctx.m_43725_();
        boolean water = level.m_6425_(pos = ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(water));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CraftingStationBlockEntity(pPos, pState);
    }

    static {
        WATERLOGGED = BlockStateProperties.f_61362_;
        FACING = HorizontalDirectionalBlock.f_54117_;
        VoxelShape[] shapes = new VoxelShape[]{Block.m_49796_((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0), Block.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0), Block.m_49796_((double)0.0, (double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0), Block.m_49796_((double)12.0, (double)0.0, (double)12.0, (double)16.0, (double)12.0, (double)16.0)};
        shape = Shapes.m_83124_((VoxelShape)shapes[0], (VoxelShape[])new VoxelShape[]{shapes[1], shapes[2], shapes[3], shapes[4]});
    }
}

