/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.network;

import com.leclowndu93150.leaderboards.data.Leaderboard;
import com.leclowndu93150.leaderboards.gui.LeaderboardListScreen;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;

public class LeaderboardListResponsePacket {
    private final Map<ResourceLocation, Component> leaderboards;

    public LeaderboardListResponsePacket(Map<ResourceLocation, Component> leaderboards) {
        this.leaderboards = leaderboards;
    }

    public static void encode(LeaderboardListResponsePacket packet, FriendlyByteBuf buf) {
        buf.m_130130_(packet.leaderboards.size());
        for (Map.Entry<ResourceLocation, Component> entry : packet.leaderboards.entrySet()) {
            buf.m_130085_(entry.getKey());
            buf.m_130083_(entry.getValue());
        }
    }

    public static LeaderboardListResponsePacket decode(FriendlyByteBuf buf) {
        int size = buf.m_130242_();
        LinkedHashMap<ResourceLocation, Component> map = new LinkedHashMap<ResourceLocation, Component>();
        for (int i = 0; i < size; ++i) {
            ResourceLocation id = buf.m_130281_();
            Component title = buf.m_130238_();
            map.put(id, title);
        }
        return new LeaderboardListResponsePacket(map);
    }

    public static LeaderboardListResponsePacket fromLeaderboards(Map<ResourceLocation, Leaderboard> leaderboards) {
        LinkedHashMap<ResourceLocation, Component> map = new LinkedHashMap<ResourceLocation, Component>();
        for (Map.Entry<ResourceLocation, Leaderboard> entry : leaderboards.entrySet()) {
            map.put(entry.getKey(), entry.getValue().getTitle());
        }
        return new LeaderboardListResponsePacket(map);
    }

    public static void handle(LeaderboardListResponsePacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> Minecraft.m_91087_().execute(() -> {
            LeaderboardListScreen screen = new LeaderboardListScreen(packet.leaderboards);
            screen.openGui();
        }));
        ctx.get().setPacketHandled(true);
    }
}

