/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards.integration;

import com.leclowndu93150.leaderboards.data.PlayerStatsWrapper;
import dev.ftb.mods.ftbquests.api.FTBQuestsAPI;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.ModList;

public class FTBQuestsIntegration {
    private static final String FTBQUESTS_MOD_ID = "ftbquests";

    public static boolean isAvailable() {
        return ModList.get().isLoaded(FTBQUESTS_MOD_ID);
    }

    public static int getPlayerQuestCompletions(PlayerStatsWrapper player) {
        if (!player.isOnline()) {
            return 0;
        }
        return FTBQuestsIntegration.getPlayerQuestCompletionsInternal(player.getOnlinePlayer());
    }

    private static int getPlayerQuestCompletionsInternal(ServerPlayer player) {
        if (!FTBQuestsIntegration.isAvailable()) {
            return 0;
        }
        try {
            ServerQuestFile questFile = (ServerQuestFile)FTBQuestsAPI.api().getQuestFile(false);
            if (questFile == null) {
                return 0;
            }
            TeamData teamData = questFile.getOrCreateTeamData((Entity)player);
            if (teamData == null) {
                return 0;
            }
            int[] completedCount = new int[]{0};
            questFile.forAllQuests(quest -> {
                if (teamData.isCompleted((QuestObject)quest)) {
                    completedCount[0] = completedCount[0] + 1;
                }
            });
            return completedCount[0];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int getTotalQuestCount() {
        if (!FTBQuestsIntegration.isAvailable()) {
            return 0;
        }
        try {
            ServerQuestFile questFile = (ServerQuestFile)FTBQuestsAPI.api().getQuestFile(false);
            if (questFile == null) {
                return 0;
            }
            int[] totalCount = new int[]{0};
            questFile.forAllQuests(quest -> {
                totalCount[0] = totalCount[0] + 1;
            });
            return totalCount[0];
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static double getQuestCompletionPercentage(PlayerStatsWrapper player) {
        int completed = FTBQuestsIntegration.getPlayerQuestCompletions(player);
        int total = FTBQuestsIntegration.getTotalQuestCount();
        if (total == 0) {
            return 0.0;
        }
        return (double)completed / (double)total * 100.0;
    }
}

