/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.leaderboards;

import com.leclowndu93150.leaderboards.LeaderboardRegistry;
import com.leclowndu93150.leaderboards.client.LeaderboardsClientEvents;
import com.leclowndu93150.leaderboards.data.PlayerDataTracker;
import com.leclowndu93150.leaderboards.network.LeaderboardListResponsePacket;
import com.leclowndu93150.leaderboards.network.LeaderboardResponsePacket;
import com.leclowndu93150.leaderboards.network.RequestLeaderboardListPacket;
import com.leclowndu93150.leaderboards.network.RequestLeaderboardPacket;
import com.mojang.logging.LogUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;

@Mod(value="leaderboards")
public class Leaderboards {
    public static final String MODID = "leaderboards";
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("leaderboards", "main"), () -> "1", "1"::equals, "1"::equals);

    public Leaderboards() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::onServerStarted);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLogin);
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerLogout);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            LeaderboardsClientEvents.init();
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            int id = 0;
            NETWORK.registerMessage(id++, RequestLeaderboardListPacket.class, RequestLeaderboardListPacket::encode, RequestLeaderboardListPacket::decode, RequestLeaderboardListPacket::handle);
            NETWORK.registerMessage(id++, LeaderboardListResponsePacket.class, LeaderboardListResponsePacket::encode, LeaderboardListResponsePacket::decode, LeaderboardListResponsePacket::handle);
            NETWORK.registerMessage(id++, RequestLeaderboardPacket.class, RequestLeaderboardPacket::encode, RequestLeaderboardPacket::decode, RequestLeaderboardPacket::handle);
            NETWORK.registerMessage(id++, LeaderboardResponsePacket.class, LeaderboardResponsePacket::encode, LeaderboardResponsePacket::decode, LeaderboardResponsePacket::handle);
            LeaderboardRegistry.register();
            LOGGER.info("Leaderboards registered");
        });
    }

    private void onServerStarted(ServerStartedEvent event) {
        PlayerDataTracker tracker = PlayerDataTracker.get(event.getServer().m_129783_());
        PlayerDataTracker.setInstance(tracker);
    }

    private void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        PlayerDataTracker tracker = PlayerDataTracker.get(event.getEntity().m_20194_().m_129783_());
        tracker.updateLastSeen(event.getEntity().m_20148_(), event.getEntity().m_20194_().m_129783_().m_46467_());
    }

    private void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity().m_9236_().f_46443_) {
            return;
        }
        PlayerDataTracker tracker = PlayerDataTracker.get(event.getEntity().m_20194_().m_129783_());
        tracker.updateLastSeen(event.getEntity().m_20148_(), event.getEntity().m_20194_().m_129783_().m_46467_());
    }
}

