/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.text;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.NonNullFunction;

public final class TextHelper {
    public static final NonNullFunction<MutableComponent, MutableComponent> IDENTITY_TEXT_POST_PROCESSOR = $ -> $;

    public static MutableComponent literal(String text) {
        return Strings.isNullOrEmpty((String)text) ? Component.m_237119_() : Component.m_237113_((String)text);
    }

    public static MutableComponent literal(String text, NonNullFunction<MutableComponent, MutableComponent> textPostProcessor) {
        Preconditions.checkNotNull(textPostProcessor, (Object)"Text post processor must not be null or empty.");
        return (MutableComponent)textPostProcessor.apply((Object)TextHelper.literal(text));
    }

    public static MutableComponent literal(String format, Object ... arguments) {
        return TextHelper.literal(String.format(format, arguments));
    }

    public static MutableComponent literal(String format, NonNullFunction<MutableComponent, MutableComponent> textPostProcessor, Object ... arguments) {
        return TextHelper.literal(String.format(format, arguments), textPostProcessor);
    }

    public static MutableComponent translatable(String langKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)langKey) ? 1 : 0) != 0, (Object)"Lang key must not be null or empty.");
        return Component.m_237115_((String)langKey);
    }

    public static MutableComponent translatable(String langKey, NonNullFunction<MutableComponent, MutableComponent> textPostProcessor) {
        Preconditions.checkNotNull(textPostProcessor, (Object)"Text post processor must not be null or empty.");
        return (MutableComponent)textPostProcessor.apply((Object)TextHelper.translatable(langKey));
    }

    public static MutableComponent translatable(String langKey, Object ... arguments) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)langKey) ? 1 : 0) != 0, (Object)"Lang key must not be null or empty.");
        Preconditions.checkArgument((arguments.length > 0 ? 1 : 0) != 0, (Object)"Arguments must not be empty.");
        return Component.m_237110_((String)langKey, (Object[])arguments);
    }

    public static MutableComponent translatable(String langKey, NonNullFunction<MutableComponent, MutableComponent> textPostProcessor, Object ... arguments) {
        Preconditions.checkNotNull(textPostProcessor, (Object)"Text post processor must not be null or empty.");
        return (MutableComponent)textPostProcessor.apply((Object)TextHelper.translatable(langKey, arguments));
    }

    private TextHelper() {
    }
}

