/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item.inventory.container.data;

import com.google.common.base.Preconditions;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModContainer;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.AbstractData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.IContainerData;
import it.zerono.mods.zerocore.lib.item.inventory.container.data.Sampler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.util.NonNullConsumer;
import net.minecraftforge.common.util.NonNullSupplier;
import org.jetbrains.annotations.Nullable;

public class StringData
extends AbstractData<String>
implements IContainerData {
    private final int _maxLength;
    private String _lastValue;

    public static StringData immutable(ModContainer container, boolean isClientSide, int maxLength, String value) {
        Preconditions.checkNotNull((Object)value, (Object)"Value must not be null.");
        Preconditions.checkArgument((value.length() <= maxLength ? 1 : 0) != 0, (Object)"Value is too big.");
        return StringData.of(container, isClientSide, maxLength, (NonNullSupplier<Supplier<String>>)((NonNullSupplier)() -> () -> value));
    }

    public static StringData sampled(int frequency, ModContainer container, boolean isClientSide, int maxLength, NonNullSupplier<Supplier<String>> serverSideGetter) {
        return StringData.of(container, isClientSide, maxLength, (NonNullSupplier<Supplier<String>>)((NonNullSupplier)() -> new Sampler(frequency, serverSideGetter)));
    }

    public static StringData of(ModContainer container, boolean isClientSide, int maxLength, NonNullSupplier<Supplier<String>> serverSideGetter) {
        Preconditions.checkNotNull((Object)container, (Object)"Container must not be null.");
        Preconditions.checkNotNull(serverSideGetter, (Object)"Server side getter must not be null.");
        StringData data = isClientSide ? new StringData(maxLength) : new StringData(maxLength, serverSideGetter);
        container.addBindableData(data);
        return data;
    }

    public static StringData of(ModContainer container, boolean isClientSide, int maxLength, String[] array, int index) {
        Preconditions.checkNotNull((Object)array, (Object)"Array must not be null.");
        Preconditions.checkArgument((index >= 0 && index < array.length ? 1 : 0) != 0, (Object)"Index must be a valid index for the array.");
        StringData data = StringData.of(container, isClientSide, maxLength, (NonNullSupplier<Supplier<String>>)((NonNullSupplier)() -> () -> array[index]));
        if (isClientSide) {
            data.bind(v -> {
                array[index] = v;
            });
        }
        return data;
    }

    @Override
    @Nullable
    public NonNullConsumer<FriendlyByteBuf> getContainerDataWriter() {
        String current = (String)this._getter.get();
        if (!this._lastValue.equals(current)) {
            this._lastValue = current;
            return buffer -> buffer.m_130072_(current, this._maxLength);
        }
        return null;
    }

    @Override
    public void readContainerData(FriendlyByteBuf dataSource) {
        this.notify(dataSource.m_130136_(this._maxLength));
    }

    @Override
    @Nullable
    public String defaultValue() {
        return "";
    }

    private StringData(int maxLength) {
        this._maxLength = maxLength;
    }

    private StringData(int maxLength, NonNullSupplier<Supplier<String>> serverSideGetter) {
        super(serverSideGetter);
        this._maxLength = maxLength;
        this._lastValue = "";
    }
}

