/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.widgets.lists;

import caeruleusTait.world.preview.client.gui.screens.PreviewContainer;
import caeruleusTait.world.preview.client.gui.widgets.lists.BaseObjectSelectionList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class SeedsList
extends BaseObjectSelectionList<SeedEntry> {
    private final PreviewContainer previewContainer;
    private final boolean seedCanChange;

    public SeedsList(Minecraft minecraft, PreviewContainer previewContainer) {
        super(minecraft, 100, 100, 0, 0, 24);
        this.previewContainer = previewContainer;
        this.seedCanChange = this.previewContainer.dataProvider().seedIsEditable();
    }

    public SeedEntry createEntry(String seed) {
        return new SeedEntry(this, seed);
    }

    public class SeedEntry
    extends BaseObjectSelectionList.Entry<SeedEntry> {
        public final SeedsList seedsList;
        public final String seed;
        public final Button deleteButton;

        public SeedEntry(SeedsList seedsList, String seed) {
            this.seedsList = seedsList;
            this.seed = seed;
            this.deleteButton = new ImageButton(0, 0, 20, 20, 40, 20, 20, PreviewContainer.BUTTONS_TEXTURE, 400, 60, this::deleteEntry);
            this.deleteButton.f_93623_ = SeedsList.this.seedCanChange;
        }

        private void deleteEntry(Button btn) {
            this.seedsList.previewContainer.deleteSeed(this.seed);
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237110_((String)"narrator.select", (Object[])new Object[]{this.seed});
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean bl, float partialTick) {
            guiGraphics.m_280488_(((SeedsList)this.seedsList).f_93386_.f_91062_, this.seed, left + 4, top + 6, SeedsList.this.seedCanChange ? 0xFFFFFF : 0x999999);
            this.deleteButton.m_264152_(this.seedsList.m_93520_() - 22, top);
            this.deleteButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }

        public boolean m_6375_(double d, double e, int i) {
            if (!SeedsList.this.seedCanChange) {
                return true;
            }
            if (this.deleteButton.m_274382_()) {
                this.deleteButton.m_6375_(d, e, i);
            }
            if (i == 0 && d < (double)(this.seedsList.m_93520_() - 22)) {
                this.seedsList.m_6987_((AbstractSelectionList.Entry)this);
                this.seedsList.previewContainer.setSeed(this.seed);
                SeedsList.this.f_93386_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                return true;
            }
            return false;
        }
    }
}

