/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.client.gui.screens.settings;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.client.WorldPreviewComponents;
import caeruleusTait.world.preview.client.gui.widgets.WGLabel;
import caeruleusTait.world.preview.client.gui.widgets.lists.AbstractSelectionListHolder;
import caeruleusTait.world.preview.client.gui.widgets.lists.BaseObjectSelectionList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.tabs.Tab;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class DimensionsTab
implements Tab {
    private final Minecraft minecraft;
    private final RenderSettings renderSettings;
    private final WGLabel headLabel;
    private final DimensionList dimensionList;
    private final AbstractSelectionListHolder<DimensionList.DimensionEntry, DimensionList> dimensionListHolder;

    public DimensionsTab(Minecraft minecraft, List<ResourceLocation> levelStemKeys) {
        this.minecraft = minecraft;
        this.renderSettings = WorldPreview.get().renderSettings();
        this.headLabel = new WGLabel(minecraft.f_91062_, 0, 0, 256, 20, WGLabel.TextAlignment.CENTER, WorldPreviewComponents.SETTINGS_DIM_HEAD, -1);
        this.dimensionList = new DimensionList(minecraft, 256, 100, 0, 0);
        this.dimensionList.m_5988_(levelStemKeys.stream().map(this.dimensionList::entryFactory).toList());
        this.dimensionList.select(this.renderSettings.dimension);
        this.dimensionListHolder = new AbstractSelectionListHolder(this.dimensionList, 0, 0, 256, 100, WorldPreviewComponents.SETTINGS_DIM_TITLE);
    }

    @NotNull
    public Component m_267600_() {
        return WorldPreviewComponents.SETTINGS_DIM_TITLE;
    }

    public void m_267609_(Consumer<AbstractWidget> consumer) {
        consumer.accept(this.headLabel);
        consumer.accept(this.dimensionListHolder);
    }

    public void m_267697_(ScreenRectangle rectangle) {
        int width = Math.min(rectangle.f_263770_() - 8, 256);
        int center = rectangle.m_274563_() + rectangle.f_263770_() / 2;
        int left = center - width / 2;
        int top = rectangle.m_274449_() + 4;
        int bottom = rectangle.m_274349_() - 16;
        this.headLabel.m_93674_(width);
        this.headLabel.m_264152_(left, top);
        this.dimensionListHolder.m_264152_(left, top += 24);
        this.dimensionListHolder.setSize(width, bottom - top);
        this.dimensionList.m_93488_(true);
        this.dimensionList.m_93496_(false);
    }

    public class DimensionList
    extends BaseObjectSelectionList<DimensionEntry> {
        public DimensionList(Minecraft minecraft, int width, int height, int x, int y) {
            super(minecraft, width, height, x, y, 16);
        }

        public DimensionEntry entryFactory(ResourceLocation dimensionKey) {
            return new DimensionEntry(dimensionKey);
        }

        public void select(ResourceLocation dimensionKey) {
            for (DimensionEntry entry : this.m_6702_()) {
                if (!entry.dimensionKey.equals((Object)dimensionKey)) continue;
                this.m_6987_((AbstractSelectionList.Entry)entry);
                return;
            }
            this.m_6987_(null);
        }

        public class DimensionEntry
        extends BaseObjectSelectionList.Entry<DimensionEntry> {
            private final ResourceLocation dimensionKey;
            private final Component component;

            public DimensionEntry(ResourceLocation dimensionKey) {
                this.dimensionKey = dimensionKey;
                this.component = Component.m_237113_((String)dimensionKey.toString());
            }

            @NotNull
            public Component m_142172_() {
                return Component.m_237113_((String)"");
            }

            public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean bl, float partialTick) {
                guiGraphics.m_280430_(((DimensionList)DimensionList.this).f_93386_.f_91062_, this.component, left + 5, top + 2, 0xFFFFFF);
            }

            public boolean m_6375_(double d, double e, int i) {
                if (i != 0) {
                    return false;
                }
                DimensionList.this.f_93386_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                DimensionsTab.this.renderSettings.dimension = this.dimensionKey;
                return true;
            }
        }
    }
}

