/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.worker;

import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.backend.WorkManager;
import caeruleusTait.world.preview.backend.color.PreviewData;
import caeruleusTait.world.preview.backend.storage.PreviewSection;
import caeruleusTait.world.preview.backend.storage.PreviewStorage;
import caeruleusTait.world.preview.backend.worker.SampleUtils;
import caeruleusTait.world.preview.backend.worker.WorkResult;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;

public abstract class WorkUnit {
    protected final WorkManager workManager = WorldPreview.get().workManager();
    protected final SampleUtils sampleUtils;
    protected final PreviewStorage storage;
    protected final PreviewSection primarySection;
    protected final ChunkPos chunkPos;
    protected final PreviewData previewData;
    protected final int y;
    private boolean isCanceled;

    protected WorkUnit(SampleUtils sampleUtils, ChunkPos chunkPos, PreviewData previewData, int y) {
        this.sampleUtils = sampleUtils;
        this.storage = this.workManager.previewStorage();
        this.primarySection = this.storage.section4(chunkPos, y, this.flags());
        this.chunkPos = chunkPos;
        this.previewData = previewData;
        this.y = y;
    }

    public short biomeIdFrom(ResourceKey<Biome> resourceKey) {
        return this.previewData.biome2Id().getShort((Object)resourceKey.m_135782_().toString());
    }

    public short biomeIdFrom(ResourceLocation location) {
        return this.previewData.biome2Id().getShort((Object)location.toString());
    }

    protected abstract List<WorkResult> doWork();

    public abstract long flags();

    public boolean isCompleted() {
        return this.primarySection.isCompleted(this.chunkPos);
    }

    public void markCompleted() {
        this.primarySection.markCompleted(this.chunkPos);
    }

    public List<WorkResult> work() {
        try {
            return this.doWork();
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
    }

    public ChunkPos chunk() {
        return this.chunkPos;
    }

    public int y() {
        return this.y;
    }

    public void cancel() {
        this.isCanceled = true;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }
}

