/*
 * Decompiled with CFR 0.152.
 */
package caeruleusTait.world.preview.backend.storage;

import caeruleusTait.world.preview.RenderSettings;
import caeruleusTait.world.preview.WorldPreview;
import caeruleusTait.world.preview.WorldPreviewConfig;
import caeruleusTait.world.preview.backend.storage.PreviewStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public interface PreviewStorageCacheManager {
    public static final int CACHE_FORMAT_VERSION = 1;

    public PreviewStorage loadPreviewStorage(long var1, int var3, int var4);

    public void storePreviewStorage(long var1, PreviewStorage var3);

    public Path cacheDir();

    default public String cacheFileCompatPart() {
        WorldPreview worldPreview = WorldPreview.get();
        RenderSettings settings = worldPreview.renderSettings();
        WorldPreviewConfig cfg = worldPreview.cfg();
        long flags = 0L;
        flags |= 1L;
        flags |= (long)((settings.samplerType.ordinal() & 0xF) << 4);
        flags |= 0x600L;
        flags |= 0x5000L;
        return String.format("%s-%d-%d", settings.dimension, settings.pixelsPerChunk(), flags |= cfg.enableCompression ? 65536L : 0L).replace(":", "_").replace(";", "_").replace("/", "_").replace("\\", "_");
    }

    default public void clearCache() {
        try (Stream<Path> stream = Files.walk(this.cacheDir(), new FileVisitOption[0]);){
            stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    default public void writeCacheFile(PreviewStorage storage, Path outFile) {
        Path outFileTmp = outFile.getParent().resolve(outFile.getFileName().toString() + ".tmp");
        WorldPreview.LOGGER.info("Writing preview data to {}", (Object)outFile);
        ZipEntry entry = new ZipEntry("bin");
        try (FileOutputStream fos = new FileOutputStream(outFileTmp.toFile());
             ZipOutputStream zos = new ZipOutputStream(fos);){
            zos.putNextEntry(entry);
            ObjectOutputStream oos = new ObjectOutputStream(zos);
            oos.writeObject(storage);
            zos.closeEntry();
        }
        catch (IOException e) {
            WorldPreview.LOGGER.error("Failed to write cached preview data to {}", (Object)outFile);
            e.printStackTrace();
        }
        try {
            Files.move(outFileTmp, outFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            WorldPreview.LOGGER.error("Failed to move cached preview data to {} --> {}", (Object)outFileTmp, (Object)outFile);
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    default public PreviewStorage readCacheFile(int yMin, int yMax, Path inFile) {
        if (!Files.exists(inFile, new LinkOption[0])) {
            return new PreviewStorage(yMin, yMax);
        }
        WorldPreview.LOGGER.info("Reading preview data from {}", (Object)inFile);
        try (FileInputStream fis = new FileInputStream(inFile.toFile());){
            PreviewStorage previewStorage;
            try (ZipInputStream zis = new ZipInputStream(fis);){
                zis.getNextEntry();
                ObjectInputStream ois = new ObjectInputStream(zis);
                previewStorage = (PreviewStorage)ois.readObject();
            }
            return previewStorage;
        }
        catch (IOException | ClassNotFoundException e) {
            WorldPreview.LOGGER.error("Failed to read cached preview data from {}", (Object)inFile);
            e.printStackTrace();
            return new PreviewStorage(yMin, yMax);
        }
    }
}

